@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrockfoundation.kotlin.inputs

import com.pulumi.aws.bedrockfoundation.inputs.GetModelPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getModel.
 * @property modelId Model identifier.
 */
public data class GetModelPlainArgs(
    public val modelId: String,
) : ConvertibleToJava<com.pulumi.aws.bedrockfoundation.inputs.GetModelPlainArgs> {
    override fun toJava(): com.pulumi.aws.bedrockfoundation.inputs.GetModelPlainArgs =
        com.pulumi.aws.bedrockfoundation.inputs.GetModelPlainArgs.builder()
            .modelId(modelId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetModelPlainArgs].
 */
@PulumiTagMarker
public class GetModelPlainArgsBuilder internal constructor() {
    private var modelId: String? = null

    /**
     * @param value Model identifier.
     */
    @JvmName("xvowhrwgwxyhnute")
    public suspend fun modelId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.modelId = mapped
    }

    internal fun build(): GetModelPlainArgs = GetModelPlainArgs(
        modelId = modelId ?: throw PulumiNullFieldException("modelId"),
    )
}
