@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrockfoundation.kotlin.inputs

import com.pulumi.aws.bedrockfoundation.inputs.GetModelsModelSummary.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property customizationsSupporteds Customizations that the model supports.
 * @property inferenceTypesSupporteds Inference types that the model supports.
 * @property inputModalities Input modalities that the model supports.
 * @property modelArn Model ARN.
 * @property modelId Model identifier.
 * @property modelName Model name.
 * @property outputModalities Output modalities that the model supports.
 * @property providerName Model provider name.
 * @property responseStreamingSupported Indicates whether the model supports streaming.
 */
public data class GetModelsModelSummary(
    public val customizationsSupporteds: List<String>,
    public val inferenceTypesSupporteds: List<String>,
    public val inputModalities: List<String>,
    public val modelArn: String,
    public val modelId: String,
    public val modelName: String,
    public val outputModalities: List<String>,
    public val providerName: String,
    public val responseStreamingSupported: Boolean,
) : ConvertibleToJava<com.pulumi.aws.bedrockfoundation.inputs.GetModelsModelSummary> {
    override fun toJava(): com.pulumi.aws.bedrockfoundation.inputs.GetModelsModelSummary =
        com.pulumi.aws.bedrockfoundation.inputs.GetModelsModelSummary.builder()
            .customizationsSupporteds(customizationsSupporteds.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .inferenceTypesSupporteds(inferenceTypesSupporteds.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .inputModalities(inputModalities.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .modelArn(modelArn.let({ args0 -> args0 }))
            .modelId(modelId.let({ args0 -> args0 }))
            .modelName(modelName.let({ args0 -> args0 }))
            .outputModalities(outputModalities.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .providerName(providerName.let({ args0 -> args0 }))
            .responseStreamingSupported(responseStreamingSupported.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetModelsModelSummary].
 */
@PulumiTagMarker
public class GetModelsModelSummaryBuilder internal constructor() {
    private var customizationsSupporteds: List<String>? = null

    private var inferenceTypesSupporteds: List<String>? = null

    private var inputModalities: List<String>? = null

    private var modelArn: String? = null

    private var modelId: String? = null

    private var modelName: String? = null

    private var outputModalities: List<String>? = null

    private var providerName: String? = null

    private var responseStreamingSupported: Boolean? = null

    /**
     * @param value Customizations that the model supports.
     */
    @JvmName("aavsjguyxpsajaur")
    public suspend fun customizationsSupporteds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.customizationsSupporteds = mapped
    }

    /**
     * @param values Customizations that the model supports.
     */
    @JvmName("kgvdnejhkfokybia")
    public suspend fun customizationsSupporteds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.customizationsSupporteds = mapped
    }

    /**
     * @param value Inference types that the model supports.
     */
    @JvmName("ctedxrhefuygnsum")
    public suspend fun inferenceTypesSupporteds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.inferenceTypesSupporteds = mapped
    }

    /**
     * @param values Inference types that the model supports.
     */
    @JvmName("yjrcmblphcnlemqd")
    public suspend fun inferenceTypesSupporteds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.inferenceTypesSupporteds = mapped
    }

    /**
     * @param value Input modalities that the model supports.
     */
    @JvmName("aepumsyekjecvfjl")
    public suspend fun inputModalities(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.inputModalities = mapped
    }

    /**
     * @param values Input modalities that the model supports.
     */
    @JvmName("gprftkxiwvpgqjow")
    public suspend fun inputModalities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.inputModalities = mapped
    }

    /**
     * @param value Model ARN.
     */
    @JvmName("hwbnlcbmogfuphbf")
    public suspend fun modelArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.modelArn = mapped
    }

    /**
     * @param value Model identifier.
     */
    @JvmName("wxiroldwalimhpue")
    public suspend fun modelId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.modelId = mapped
    }

    /**
     * @param value Model name.
     */
    @JvmName("arcscbakqfmxhlue")
    public suspend fun modelName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.modelName = mapped
    }

    /**
     * @param value Output modalities that the model supports.
     */
    @JvmName("vxdevhkxgjrfuihw")
    public suspend fun outputModalities(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.outputModalities = mapped
    }

    /**
     * @param values Output modalities that the model supports.
     */
    @JvmName("apwmladpmjyrgwoo")
    public suspend fun outputModalities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.outputModalities = mapped
    }

    /**
     * @param value Model provider name.
     */
    @JvmName("wyrkindqdwjsqycw")
    public suspend fun providerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.providerName = mapped
    }

    /**
     * @param value Indicates whether the model supports streaming.
     */
    @JvmName("nvyuchoeggnyfytd")
    public suspend fun responseStreamingSupported(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.responseStreamingSupported = mapped
    }

    internal fun build(): GetModelsModelSummary = GetModelsModelSummary(
        customizationsSupporteds = customizationsSupporteds ?: throw
            PulumiNullFieldException("customizationsSupporteds"),
        inferenceTypesSupporteds = inferenceTypesSupporteds ?: throw
            PulumiNullFieldException("inferenceTypesSupporteds"),
        inputModalities = inputModalities ?: throw PulumiNullFieldException("inputModalities"),
        modelArn = modelArn ?: throw PulumiNullFieldException("modelArn"),
        modelId = modelId ?: throw PulumiNullFieldException("modelId"),
        modelName = modelName ?: throw PulumiNullFieldException("modelName"),
        outputModalities = outputModalities ?: throw PulumiNullFieldException("outputModalities"),
        providerName = providerName ?: throw PulumiNullFieldException("providerName"),
        responseStreamingSupported = responseStreamingSupported ?: throw
            PulumiNullFieldException("responseStreamingSupported"),
    )
}
