@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrockfoundation.kotlin.inputs

import com.pulumi.aws.bedrockfoundation.inputs.GetModelsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getModels.
 * @property byCustomizationType Customization type to filter on. Valid values are `FINE_TUNING`.
 * @property byInferenceType Inference type to filter on. Valid values are `ON_DEMAND` and `PROVISIONED`.
 * @property byOutputModality Output modality to filter on. Valid values are `TEXT`, `IMAGE`, and `EMBEDDING`.
 * @property byProvider Model provider to filter on.
 * @property modelSummaries List of model summary objects. See `model_summaries`.
 */
public data class GetModelsPlainArgs(
    public val byCustomizationType: String? = null,
    public val byInferenceType: String? = null,
    public val byOutputModality: String? = null,
    public val byProvider: String? = null,
    public val modelSummaries: List<GetModelsModelSummary>? = null,
) : ConvertibleToJava<com.pulumi.aws.bedrockfoundation.inputs.GetModelsPlainArgs> {
    override fun toJava(): com.pulumi.aws.bedrockfoundation.inputs.GetModelsPlainArgs =
        com.pulumi.aws.bedrockfoundation.inputs.GetModelsPlainArgs.builder()
            .byCustomizationType(byCustomizationType?.let({ args0 -> args0 }))
            .byInferenceType(byInferenceType?.let({ args0 -> args0 }))
            .byOutputModality(byOutputModality?.let({ args0 -> args0 }))
            .byProvider(byProvider?.let({ args0 -> args0 }))
            .modelSummaries(
                modelSummaries?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetModelsPlainArgs].
 */
@PulumiTagMarker
public class GetModelsPlainArgsBuilder internal constructor() {
    private var byCustomizationType: String? = null

    private var byInferenceType: String? = null

    private var byOutputModality: String? = null

    private var byProvider: String? = null

    private var modelSummaries: List<GetModelsModelSummary>? = null

    /**
     * @param value Customization type to filter on. Valid values are `FINE_TUNING`.
     */
    @JvmName("qsmlumfggcrqlebv")
    public suspend fun byCustomizationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.byCustomizationType = mapped
    }

    /**
     * @param value Inference type to filter on. Valid values are `ON_DEMAND` and `PROVISIONED`.
     */
    @JvmName("lrjopuxntoesehvd")
    public suspend fun byInferenceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.byInferenceType = mapped
    }

    /**
     * @param value Output modality to filter on. Valid values are `TEXT`, `IMAGE`, and `EMBEDDING`.
     */
    @JvmName("vxtjhngiexthrjof")
    public suspend fun byOutputModality(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.byOutputModality = mapped
    }

    /**
     * @param value Model provider to filter on.
     */
    @JvmName("ypwshbbdmswqnlkm")
    public suspend fun byProvider(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.byProvider = mapped
    }

    /**
     * @param value List of model summary objects. See `model_summaries`.
     */
    @JvmName("hrytajdjocqjpguw")
    public suspend fun modelSummaries(`value`: List<GetModelsModelSummary>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.modelSummaries = mapped
    }

    /**
     * @param argument List of model summary objects. See `model_summaries`.
     */
    @JvmName("nanxvlomiupohbqv")
    public suspend
    fun modelSummaries(argument: List<suspend GetModelsModelSummaryBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetModelsModelSummaryBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.modelSummaries = mapped
    }

    /**
     * @param argument List of model summary objects. See `model_summaries`.
     */
    @JvmName("isqhroekibfrguxx")
    public suspend fun modelSummaries(
        vararg
        argument: suspend GetModelsModelSummaryBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GetModelsModelSummaryBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.modelSummaries = mapped
    }

    /**
     * @param argument List of model summary objects. See `model_summaries`.
     */
    @JvmName("tmteuhrksfeyhmxo")
    public suspend fun modelSummaries(argument: suspend GetModelsModelSummaryBuilder.() -> Unit) {
        val toBeMapped = listOf(GetModelsModelSummaryBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.modelSummaries = mapped
    }

    /**
     * @param values List of model summary objects. See `model_summaries`.
     */
    @JvmName("pxeksqspnuwnxeqv")
    public suspend fun modelSummaries(vararg values: GetModelsModelSummary) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.modelSummaries = mapped
    }

    internal fun build(): GetModelsPlainArgs = GetModelsPlainArgs(
        byCustomizationType = byCustomizationType,
        byInferenceType = byInferenceType,
        byOutputModality = byOutputModality,
        byProvider = byProvider,
        modelSummaries = modelSummaries,
    )
}
