@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrockmodel.kotlin

import com.pulumi.aws.bedrockmodel.InvocationLoggingConfigurationArgs.builder
import com.pulumi.aws.bedrockmodel.kotlin.inputs.InvocationLoggingConfigurationLoggingConfigArgs
import com.pulumi.aws.bedrockmodel.kotlin.inputs.InvocationLoggingConfigurationLoggingConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Manages Bedrock model invocation logging configuration.
 * > Model invocation logging is configured per AWS region. To avoid overwriting settings, this resource should not be defined in multiple configurations.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketPolicy;
 * import com.pulumi.aws.s3.BucketPolicyArgs;
 * import com.pulumi.aws.bedrockmodel.InvocationLoggingConfiguration;
 * import com.pulumi.aws.bedrockmodel.InvocationLoggingConfigurationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2", BucketV2Args.builder()
 *             .forceDestroy(true)
 *             .build());
 *         var exampleBucketPolicy = new BucketPolicy("exampleBucketPolicy", BucketPolicyArgs.builder()
 *             .bucket(exampleBucketV2.bucket())
 *             .policy(exampleBucketV2.arn().applyValue(arn -> """
 * {
 *   "Version": "2012-10-17",
 *   "Statement": [
 *     {
 *       "Effect": "Allow",
 *       "Principal": {
 *         "Service": "bedrock.amazonaws.com"
 *       },
 *       "Action": [
 *         "s3:*"
 *       ],
 *       "Resource": [
 *         "%s/*"
 *       ],
 *       "Condition": {
 *         "StringEquals": {
 *           "aws:SourceAccount": "%s"
 *         },
 *         "ArnLike": {
 *           "aws:SourceArn": "arn:aws:bedrock:us-east-1:%s:*"
 *         }
 *       }
 *     }
 *   ]
 * }
 * ", arn,current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()),current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))))
 *             .build());
 *         var exampleInvocationLoggingConfiguration = new InvocationLoggingConfiguration("exampleInvocationLoggingConfiguration", InvocationLoggingConfigurationArgs.builder()
 *             .loggingConfig(InvocationLoggingConfigurationLoggingConfigArgs.builder()
 *                 .embeddingDataDeliveryEnabled(true)
 *                 .imageDataDeliveryEnabled(true)
 *                 .textDataDeliveryEnabled(true)
 *                 .s3Config(InvocationLoggingConfigurationLoggingConfigS3ConfigArgs.builder()
 *                     .bucketName(exampleBucketV2.id())
 *                     .keyPrefix("bedrock")
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleBucketPolicy)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Bedrock custom model using the `id` set to the AWS region. For example:
 * ```sh
 *  $ pulumi import aws:bedrockmodel/invocationLoggingConfiguration:InvocationLoggingConfiguration my_config us-east-1
 * ```
 * @property loggingConfig The logging configuration values to set. See `logging_config`.
 * */
 */
public data class InvocationLoggingConfigurationArgs(
    public val loggingConfig: Output<InvocationLoggingConfigurationLoggingConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.bedrockmodel.InvocationLoggingConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.bedrockmodel.InvocationLoggingConfigurationArgs =
        com.pulumi.aws.bedrockmodel.InvocationLoggingConfigurationArgs.builder()
            .loggingConfig(loggingConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [InvocationLoggingConfigurationArgs].
 */
@PulumiTagMarker
public class InvocationLoggingConfigurationArgsBuilder internal constructor() {
    private var loggingConfig: Output<InvocationLoggingConfigurationLoggingConfigArgs>? = null

    /**
     * @param value The logging configuration values to set. See `logging_config`.
     */
    @JvmName("ryddumosyysdlkxu")
    public suspend
    fun loggingConfig(`value`: Output<InvocationLoggingConfigurationLoggingConfigArgs>) {
        this.loggingConfig = value
    }

    /**
     * @param value The logging configuration values to set. See `logging_config`.
     */
    @JvmName("gyxjawfdsmjupdvv")
    public suspend fun loggingConfig(`value`: InvocationLoggingConfigurationLoggingConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loggingConfig = mapped
    }

    /**
     * @param argument The logging configuration values to set. See `logging_config`.
     */
    @JvmName("sfvkkkuycpdtjkpe")
    public suspend
    fun loggingConfig(argument: suspend InvocationLoggingConfigurationLoggingConfigArgsBuilder.() -> Unit) {
        val toBeMapped = InvocationLoggingConfigurationLoggingConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.loggingConfig = mapped
    }

    internal fun build(): InvocationLoggingConfigurationArgs = InvocationLoggingConfigurationArgs(
        loggingConfig = loggingConfig,
    )
}
