@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrockmodel.kotlin.inputs

import com.pulumi.aws.bedrockmodel.inputs.InvocationLoggingConfigurationLoggingConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property cloudwatchConfig CloudWatch logging configuration. See `cloudwatch_config`.
 * @property embeddingDataDeliveryEnabled Set to include embeddings data in the log delivery.
 * @property imageDataDeliveryEnabled Set to include image data in the log delivery.
 * @property s3Config S3 configuration for storing log data. See `s3_config`.
 * @property textDataDeliveryEnabled Set to include text data in the log delivery.
 */
public data class InvocationLoggingConfigurationLoggingConfigArgs(
    public val cloudwatchConfig:
    Output<InvocationLoggingConfigurationLoggingConfigCloudwatchConfigArgs>? = null,
    public val embeddingDataDeliveryEnabled: Output<Boolean>,
    public val imageDataDeliveryEnabled: Output<Boolean>,
    public val s3Config: Output<InvocationLoggingConfigurationLoggingConfigS3ConfigArgs>? = null,
    public val textDataDeliveryEnabled: Output<Boolean>,
) :
    ConvertibleToJava<com.pulumi.aws.bedrockmodel.inputs.InvocationLoggingConfigurationLoggingConfigArgs> {
    override fun toJava():
        com.pulumi.aws.bedrockmodel.inputs.InvocationLoggingConfigurationLoggingConfigArgs =
        com.pulumi.aws.bedrockmodel.inputs.InvocationLoggingConfigurationLoggingConfigArgs.builder()
            .cloudwatchConfig(cloudwatchConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .embeddingDataDeliveryEnabled(embeddingDataDeliveryEnabled.applyValue({ args0 -> args0 }))
            .imageDataDeliveryEnabled(imageDataDeliveryEnabled.applyValue({ args0 -> args0 }))
            .s3Config(s3Config?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .textDataDeliveryEnabled(textDataDeliveryEnabled.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InvocationLoggingConfigurationLoggingConfigArgs].
 */
@PulumiTagMarker
public class InvocationLoggingConfigurationLoggingConfigArgsBuilder internal constructor() {
    private var cloudwatchConfig:
        Output<InvocationLoggingConfigurationLoggingConfigCloudwatchConfigArgs>? = null

    private var embeddingDataDeliveryEnabled: Output<Boolean>? = null

    private var imageDataDeliveryEnabled: Output<Boolean>? = null

    private var s3Config: Output<InvocationLoggingConfigurationLoggingConfigS3ConfigArgs>? = null

    private var textDataDeliveryEnabled: Output<Boolean>? = null

    /**
     * @param value CloudWatch logging configuration. See `cloudwatch_config`.
     */
    @JvmName("pxxmuptaccxhxjdo")
    public suspend
    fun cloudwatchConfig(`value`: Output<InvocationLoggingConfigurationLoggingConfigCloudwatchConfigArgs>) {
        this.cloudwatchConfig = value
    }

    /**
     * @param value Set to include embeddings data in the log delivery.
     */
    @JvmName("ngfckdebenxsisqa")
    public suspend fun embeddingDataDeliveryEnabled(`value`: Output<Boolean>) {
        this.embeddingDataDeliveryEnabled = value
    }

    /**
     * @param value Set to include image data in the log delivery.
     */
    @JvmName("xlkbootyceyogaim")
    public suspend fun imageDataDeliveryEnabled(`value`: Output<Boolean>) {
        this.imageDataDeliveryEnabled = value
    }

    /**
     * @param value S3 configuration for storing log data. See `s3_config`.
     */
    @JvmName("jkllshlwuwchoyui")
    public suspend
    fun s3Config(`value`: Output<InvocationLoggingConfigurationLoggingConfigS3ConfigArgs>) {
        this.s3Config = value
    }

    /**
     * @param value Set to include text data in the log delivery.
     */
    @JvmName("xdvpeqjukbihxyue")
    public suspend fun textDataDeliveryEnabled(`value`: Output<Boolean>) {
        this.textDataDeliveryEnabled = value
    }

    /**
     * @param value CloudWatch logging configuration. See `cloudwatch_config`.
     */
    @JvmName("ukvtjohckwtyqfja")
    public suspend
    fun cloudwatchConfig(`value`: InvocationLoggingConfigurationLoggingConfigCloudwatchConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchConfig = mapped
    }

    /**
     * @param argument CloudWatch logging configuration. See `cloudwatch_config`.
     */
    @JvmName("ipliajgfhrugghby")
    public suspend
    fun cloudwatchConfig(argument: suspend InvocationLoggingConfigurationLoggingConfigCloudwatchConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            InvocationLoggingConfigurationLoggingConfigCloudwatchConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.cloudwatchConfig = mapped
    }

    /**
     * @param value Set to include embeddings data in the log delivery.
     */
    @JvmName("gqwyylyvcfwsvpen")
    public suspend fun embeddingDataDeliveryEnabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.embeddingDataDeliveryEnabled = mapped
    }

    /**
     * @param value Set to include image data in the log delivery.
     */
    @JvmName("dotmbshoelnfphtv")
    public suspend fun imageDataDeliveryEnabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.imageDataDeliveryEnabled = mapped
    }

    /**
     * @param value S3 configuration for storing log data. See `s3_config`.
     */
    @JvmName("moqphvismhauohgv")
    public suspend fun s3Config(`value`: InvocationLoggingConfigurationLoggingConfigS3ConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Config = mapped
    }

    /**
     * @param argument S3 configuration for storing log data. See `s3_config`.
     */
    @JvmName("eqbdkhlkdmrlmljd")
    public suspend
    fun s3Config(argument: suspend InvocationLoggingConfigurationLoggingConfigS3ConfigArgsBuilder.() -> Unit) {
        val toBeMapped = InvocationLoggingConfigurationLoggingConfigS3ConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.s3Config = mapped
    }

    /**
     * @param value Set to include text data in the log delivery.
     */
    @JvmName("gjrwmdfxaqebfmub")
    public suspend fun textDataDeliveryEnabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textDataDeliveryEnabled = mapped
    }

    internal fun build(): InvocationLoggingConfigurationLoggingConfigArgs =
        InvocationLoggingConfigurationLoggingConfigArgs(
            cloudwatchConfig = cloudwatchConfig,
            embeddingDataDeliveryEnabled = embeddingDataDeliveryEnabled ?: throw
                PulumiNullFieldException("embeddingDataDeliveryEnabled"),
            imageDataDeliveryEnabled = imageDataDeliveryEnabled ?: throw
                PulumiNullFieldException("imageDataDeliveryEnabled"),
            s3Config = s3Config,
            textDataDeliveryEnabled = textDataDeliveryEnabled ?: throw
                PulumiNullFieldException("textDataDeliveryEnabled"),
        )
}
