@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrockmodel.kotlin.inputs

import com.pulumi.aws.bedrockmodel.inputs.InvocationLoggingConfigurationLoggingConfigCloudwatchConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property largeDataDeliveryS3Config S3 configuration for delivering a large amount of data. See `s3_config`.
 * @property logGroupName Log group name.
 * @property roleArn IAM Role ARN.
 * The following arguments are optional:
 */
public data class InvocationLoggingConfigurationLoggingConfigCloudwatchConfigArgs(
    public val largeDataDeliveryS3Config:
    Output<InvocationLoggingConfigurationLoggingConfigCloudwatchConfigLargeDataDeliveryS3ConfigArgs>? =
        null,
    public val logGroupName: Output<String>? = null,
    public val roleArn: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.bedrockmodel.inputs.InvocationLoggingConfigurationLoggingConfigCloudwatchConfigArgs> {
    override fun toJava():
        com.pulumi.aws.bedrockmodel.inputs.InvocationLoggingConfigurationLoggingConfigCloudwatchConfigArgs =
        com.pulumi.aws.bedrockmodel.inputs.InvocationLoggingConfigurationLoggingConfigCloudwatchConfigArgs.builder()
            .largeDataDeliveryS3Config(
                largeDataDeliveryS3Config?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .logGroupName(logGroupName?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InvocationLoggingConfigurationLoggingConfigCloudwatchConfigArgs].
 */
@PulumiTagMarker
public class InvocationLoggingConfigurationLoggingConfigCloudwatchConfigArgsBuilder internal
constructor() {
    private var largeDataDeliveryS3Config:
        Output<InvocationLoggingConfigurationLoggingConfigCloudwatchConfigLargeDataDeliveryS3ConfigArgs>? =
        null

    private var logGroupName: Output<String>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value S3 configuration for delivering a large amount of data. See `s3_config`.
     */
    @JvmName("yrkkopmfiiiioiuh")
    public suspend
    fun largeDataDeliveryS3Config(`value`: Output<InvocationLoggingConfigurationLoggingConfigCloudwatchConfigLargeDataDeliveryS3ConfigArgs>) {
        this.largeDataDeliveryS3Config = value
    }

    /**
     * @param value Log group name.
     */
    @JvmName("hfcjeoxvtwrckpxy")
    public suspend fun logGroupName(`value`: Output<String>) {
        this.logGroupName = value
    }

    /**
     * @param value IAM Role ARN.
     * The following arguments are optional:
     */
    @JvmName("leasshxhijplogei")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value S3 configuration for delivering a large amount of data. See `s3_config`.
     */
    @JvmName("mcaypbvpqoilkpgq")
    public suspend
    fun largeDataDeliveryS3Config(`value`: InvocationLoggingConfigurationLoggingConfigCloudwatchConfigLargeDataDeliveryS3ConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.largeDataDeliveryS3Config = mapped
    }

    /**
     * @param argument S3 configuration for delivering a large amount of data. See `s3_config`.
     */
    @JvmName("rowwudcrepdsdmqa")
    public suspend
    fun largeDataDeliveryS3Config(argument: suspend InvocationLoggingConfigurationLoggingConfigCloudwatchConfigLargeDataDeliveryS3ConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            InvocationLoggingConfigurationLoggingConfigCloudwatchConfigLargeDataDeliveryS3ConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.largeDataDeliveryS3Config = mapped
    }

    /**
     * @param value Log group name.
     */
    @JvmName("dpfkmdmuehqwugfa")
    public suspend fun logGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logGroupName = mapped
    }

    /**
     * @param value IAM Role ARN.
     * The following arguments are optional:
     */
    @JvmName("tdorlnsgrktutqax")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): InvocationLoggingConfigurationLoggingConfigCloudwatchConfigArgs =
        InvocationLoggingConfigurationLoggingConfigCloudwatchConfigArgs(
            largeDataDeliveryS3Config = largeDataDeliveryS3Config,
            logGroupName = logGroupName,
            roleArn = roleArn,
        )
}
