@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrockmodel.kotlin.inputs

import com.pulumi.aws.bedrockmodel.inputs.InvocationLoggingConfigurationLoggingConfigCloudwatchConfigLargeDataDeliveryS3ConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucketName S3 bucket name.
 * The following arguments are optional:
 * @property keyPrefix S3 object key prefix.
 */
public data class
InvocationLoggingConfigurationLoggingConfigCloudwatchConfigLargeDataDeliveryS3ConfigArgs(
    public val bucketName: Output<String>? = null,
    public val keyPrefix: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.bedrockmodel.inputs.InvocationLoggingConfigurationLoggingConfigCloudwatchConfigLargeDataDeliveryS3ConfigArgs> {
    override fun toJava():
        com.pulumi.aws.bedrockmodel.inputs.InvocationLoggingConfigurationLoggingConfigCloudwatchConfigLargeDataDeliveryS3ConfigArgs =
        com.pulumi.aws.bedrockmodel.inputs.InvocationLoggingConfigurationLoggingConfigCloudwatchConfigLargeDataDeliveryS3ConfigArgs.builder()
            .bucketName(bucketName?.applyValue({ args0 -> args0 }))
            .keyPrefix(keyPrefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InvocationLoggingConfigurationLoggingConfigCloudwatchConfigLargeDataDeliveryS3ConfigArgs].
 */
@PulumiTagMarker
public class
InvocationLoggingConfigurationLoggingConfigCloudwatchConfigLargeDataDeliveryS3ConfigArgsBuilder
internal constructor() {
    private var bucketName: Output<String>? = null

    private var keyPrefix: Output<String>? = null

    /**
     * @param value S3 bucket name.
     * The following arguments are optional:
     */
    @JvmName("bkowvvyenyylqfcf")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value S3 object key prefix.
     */
    @JvmName("cqdsghqtibdhgfpf")
    public suspend fun keyPrefix(`value`: Output<String>) {
        this.keyPrefix = value
    }

    /**
     * @param value S3 bucket name.
     * The following arguments are optional:
     */
    @JvmName("pqtitrhtwjwgqbhl")
    public suspend fun bucketName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value S3 object key prefix.
     */
    @JvmName("yqaggowgjgaenwuc")
    public suspend fun keyPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyPrefix = mapped
    }

    internal fun build():
        InvocationLoggingConfigurationLoggingConfigCloudwatchConfigLargeDataDeliveryS3ConfigArgs =
        InvocationLoggingConfigurationLoggingConfigCloudwatchConfigLargeDataDeliveryS3ConfigArgs(
            bucketName = bucketName,
            keyPrefix = keyPrefix,
        )
}
