@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrockmodel.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property cloudwatchConfig CloudWatch logging configuration. See `cloudwatch_config`.
 * @property embeddingDataDeliveryEnabled Set to include embeddings data in the log delivery.
 * @property imageDataDeliveryEnabled Set to include image data in the log delivery.
 * @property s3Config S3 configuration for storing log data. See `s3_config`.
 * @property textDataDeliveryEnabled Set to include text data in the log delivery.
 */
public data class InvocationLoggingConfigurationLoggingConfig(
    public val cloudwatchConfig: InvocationLoggingConfigurationLoggingConfigCloudwatchConfig? = null,
    public val embeddingDataDeliveryEnabled: Boolean,
    public val imageDataDeliveryEnabled: Boolean,
    public val s3Config: InvocationLoggingConfigurationLoggingConfigS3Config? = null,
    public val textDataDeliveryEnabled: Boolean,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.bedrockmodel.outputs.InvocationLoggingConfigurationLoggingConfig):
            InvocationLoggingConfigurationLoggingConfig = InvocationLoggingConfigurationLoggingConfig(
            cloudwatchConfig = javaType.cloudwatchConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.bedrockmodel.kotlin.outputs.InvocationLoggingConfigurationLoggingConfigCloudwatchConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            embeddingDataDeliveryEnabled = javaType.embeddingDataDeliveryEnabled(),
            imageDataDeliveryEnabled = javaType.imageDataDeliveryEnabled(),
            s3Config = javaType.s3Config().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.bedrockmodel.kotlin.outputs.InvocationLoggingConfigurationLoggingConfigS3Config.Companion.toKotlin(args0)
                })
            }).orElse(null),
            textDataDeliveryEnabled = javaType.textDataDeliveryEnabled(),
        )
    }
}
