@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin

import com.pulumi.aws.budgets.kotlin.outputs.BudgetAutoAdjustData
import com.pulumi.aws.budgets.kotlin.outputs.BudgetCostFilter
import com.pulumi.aws.budgets.kotlin.outputs.BudgetCostTypes
import com.pulumi.aws.budgets.kotlin.outputs.BudgetNotification
import com.pulumi.aws.budgets.kotlin.outputs.BudgetPlannedLimit
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.budgets.kotlin.outputs.BudgetAutoAdjustData.Companion.toKotlin as budgetAutoAdjustDataToKotlin
import com.pulumi.aws.budgets.kotlin.outputs.BudgetCostFilter.Companion.toKotlin as budgetCostFilterToKotlin
import com.pulumi.aws.budgets.kotlin.outputs.BudgetCostTypes.Companion.toKotlin as budgetCostTypesToKotlin
import com.pulumi.aws.budgets.kotlin.outputs.BudgetNotification.Companion.toKotlin as budgetNotificationToKotlin
import com.pulumi.aws.budgets.kotlin.outputs.BudgetPlannedLimit.Companion.toKotlin as budgetPlannedLimitToKotlin

/**
 * Builder for [Budget].
 */
@PulumiTagMarker
public class BudgetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BudgetArgs = BudgetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BudgetArgsBuilder.() -> Unit) {
        val builder = BudgetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Budget {
        val builtJavaResource = com.pulumi.aws.budgets.Budget(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Budget(builtJavaResource)
    }
}

/**
 * Provides a budgets budget resource. Budgets use the cost visualisation provided by Cost Explorer to show you the status of your budgets, to provide forecasts of your estimated costs, and to track your AWS usage, including your free tier usage.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.budgets.Budget;
 * import com.pulumi.aws.budgets.BudgetArgs;
 * import com.pulumi.aws.budgets.inputs.BudgetCostFilterArgs;
 * import com.pulumi.aws.budgets.inputs.BudgetNotificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ec2 = new Budget("ec2", BudgetArgs.builder()
 *             .budgetType("COST")
 *             .costFilters(BudgetCostFilterArgs.builder()
 *                 .name("Service")
 *                 .values("Amazon Elastic Compute Cloud - Compute")
 *                 .build())
 *             .limitAmount("1200")
 *             .limitUnit("USD")
 *             .notifications(BudgetNotificationArgs.builder()
 *                 .comparisonOperator("GREATER_THAN")
 *                 .notificationType("FORECASTED")
 *                 .subscriberEmailAddresses("test@example.com")
 *                 .threshold(100)
 *                 .thresholdType("PERCENTAGE")
 *                 .build())
 *             .timePeriodEnd("2087-06-15_00:00")
 *             .timePeriodStart("2017-07-01_00:00")
 *             .timeUnit("MONTHLY")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import budgets using `AccountID:BudgetName`. For example:
 * ```sh
 *  $ pulumi import aws:budgets/budget:Budget myBudget 123456789012:myBudget
 * ```
 *
 */
public class Budget internal constructor(
    override val javaResource: com.pulumi.aws.budgets.Budget,
) : KotlinCustomResource(javaResource, BudgetMapper) {
    /**
     * The ID of the target account for budget. Will use current user's account_id by default if omitted.
     */
    public val accountId: Output<String>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })

    /**
     * The ARN of the budget.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Object containing [AutoAdjustData] which determines the budget amount for an auto-adjusting budget.
     */
    public val autoAdjustData: Output<BudgetAutoAdjustData>?
        get() = javaResource.autoAdjustData().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> budgetAutoAdjustDataToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Whether this budget tracks monetary cost or usage.
     */
    public val budgetType: Output<String>
        get() = javaResource.budgetType().applyValue({ args0 -> args0 })

    /**
     * A list of CostFilter name/values pair to apply to budget.
     */
    public val costFilters: Output<List<BudgetCostFilter>>
        get() = javaResource.costFilters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    budgetCostFilterToKotlin(args0)
                })
            })
        })

    /**
     * Object containing CostTypes The types of cost included in a budget, such as tax and subscriptions.
     */
    public val costTypes: Output<BudgetCostTypes>
        get() = javaResource.costTypes().applyValue({ args0 ->
            args0.let({ args0 ->
                budgetCostTypesToKotlin(args0)
            })
        })

    /**
     * The amount of cost or usage being measured for a budget.
     */
    public val limitAmount: Output<String>
        get() = javaResource.limitAmount().applyValue({ args0 -> args0 })

    /**
     * The unit of measurement used for the budget forecast, actual spend, or budget threshold, such as dollars or GB. See [Spend](http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/data-type-spend.html) documentation.
     */
    public val limitUnit: Output<String>
        get() = javaResource.limitUnit().applyValue({ args0 -> args0 })

    /**
     * The name of a budget. Unique within accounts.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The prefix of the name of a budget. Unique within accounts.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * Object containing Budget Notifications. Can be used multiple times to define more than one budget notification.
     */
    public val notifications: Output<List<BudgetNotification>>?
        get() = javaResource.notifications().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        budgetNotificationToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Object containing Planned Budget Limits. Can be used multiple times to plan more than one budget limit. See [PlannedBudgetLimits](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_Budget.html#awscostmanagement-Type-budgets_Budget-PlannedBudgetLimits) documentation.
     */
    public val plannedLimits: Output<List<BudgetPlannedLimit>>?
        get() = javaResource.plannedLimits().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        budgetPlannedLimitToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The end of the time period covered by the budget. There are no restrictions on the end date. Format: `2017-01-01_12:00`.
     */
    public val timePeriodEnd: Output<String>?
        get() = javaResource.timePeriodEnd().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The start of the time period covered by the budget. If you don't specify a start date, AWS defaults to the start of your chosen time period. The start date must come before the end date. Format: `2017-01-01_12:00`.
     */
    public val timePeriodStart: Output<String>
        get() = javaResource.timePeriodStart().applyValue({ args0 -> args0 })

    /**
     * The length of time until a budget resets the actual and forecasted spend. Valid values: `MONTHLY`, `QUARTERLY`, `ANNUALLY`, and `DAILY`.
     */
    public val timeUnit: Output<String>
        get() = javaResource.timeUnit().applyValue({ args0 -> args0 })
}

public object BudgetMapper : ResourceMapper<Budget> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.budgets.Budget::class == javaResource::class

    override fun map(javaResource: Resource): Budget = Budget(
        javaResource as
            com.pulumi.aws.budgets.Budget,
    )
}

/**
 * @see [Budget].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Budget].
 */
public suspend fun budget(name: String, block: suspend BudgetResourceBuilder.() -> Unit): Budget {
    val builder = BudgetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Budget].
 * @param name The _unique_ name of the resulting resource.
 */
public fun budget(name: String): Budget {
    val builder = BudgetResourceBuilder()
    builder.name(name)
    return builder.build()
}
