@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin

import com.pulumi.aws.budgets.kotlin.outputs.BudgetActionActionThreshold
import com.pulumi.aws.budgets.kotlin.outputs.BudgetActionDefinition
import com.pulumi.aws.budgets.kotlin.outputs.BudgetActionSubscriber
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.budgets.kotlin.outputs.BudgetActionActionThreshold.Companion.toKotlin as budgetActionActionThresholdToKotlin
import com.pulumi.aws.budgets.kotlin.outputs.BudgetActionDefinition.Companion.toKotlin as budgetActionDefinitionToKotlin
import com.pulumi.aws.budgets.kotlin.outputs.BudgetActionSubscriber.Companion.toKotlin as budgetActionSubscriberToKotlin

/**
 * Builder for [BudgetAction].
 */
@PulumiTagMarker
public class BudgetActionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BudgetActionArgs = BudgetActionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BudgetActionArgsBuilder.() -> Unit) {
        val builder = BudgetActionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BudgetAction {
        val builtJavaResource = com.pulumi.aws.budgets.BudgetAction(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BudgetAction(builtJavaResource)
    }
}

/**
 * Provides a budget action resource. Budget actions are cost savings controls that run either automatically on your behalf or by using a workflow approval process.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Policy;
 * import com.pulumi.aws.iam.PolicyArgs;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetPartitionArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.budgets.Budget;
 * import com.pulumi.aws.budgets.BudgetArgs;
 * import com.pulumi.aws.budgets.BudgetAction;
 * import com.pulumi.aws.budgets.BudgetActionArgs;
 * import com.pulumi.aws.budgets.inputs.BudgetActionActionThresholdArgs;
 * import com.pulumi.aws.budgets.inputs.BudgetActionDefinitionArgs;
 * import com.pulumi.aws.budgets.inputs.BudgetActionDefinitionIamActionDefinitionArgs;
 * import com.pulumi.aws.budgets.inputs.BudgetActionSubscriberArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("ec2:Describe*")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var examplePolicy = new Policy("examplePolicy", PolicyArgs.builder()
 *             .description("My example policy")
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         final var current = AwsFunctions.getPartition();
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers(String.format("budgets.%s", current.applyValue(getPartitionResult -> getPartitionResult.dnsSuffix())))
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleBudget = new Budget("exampleBudget", BudgetArgs.builder()
 *             .budgetType("USAGE")
 *             .limitAmount("10.0")
 *             .limitUnit("dollars")
 *             .timePeriodStart("2006-01-02_15:04")
 *             .timeUnit("MONTHLY")
 *             .build());
 *         var exampleBudgetAction = new BudgetAction("exampleBudgetAction", BudgetActionArgs.builder()
 *             .budgetName(exampleBudget.name())
 *             .actionType("APPLY_IAM_POLICY")
 *             .approvalModel("AUTOMATIC")
 *             .notificationType("ACTUAL")
 *             .executionRoleArn(exampleRole.arn())
 *             .actionThreshold(BudgetActionActionThresholdArgs.builder()
 *                 .actionThresholdType("ABSOLUTE_VALUE")
 *                 .actionThresholdValue(100)
 *                 .build())
 *             .definition(BudgetActionDefinitionArgs.builder()
 *                 .iamActionDefinition(BudgetActionDefinitionIamActionDefinitionArgs.builder()
 *                     .policyArn(examplePolicy.arn())
 *                     .roles(exampleRole.name())
 *                     .build())
 *                 .build())
 *             .subscribers(BudgetActionSubscriberArgs.builder()
 *                 .address("example@example.example")
 *                 .subscriptionType("EMAIL")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import budget actions using `AccountID:ActionID:BudgetName`. For example:
 * ```sh
 *  $ pulumi import aws:budgets/budgetAction:BudgetAction myBudget 123456789012:some-id:myBudget
 * ```
 *
 */
public class BudgetAction internal constructor(
    override val javaResource: com.pulumi.aws.budgets.BudgetAction,
) : KotlinCustomResource(javaResource, BudgetActionMapper) {
    /**
     * The ID of the target account for budget. Will use current user's account_id by default if omitted.
     */
    public val accountId: Output<String>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })

    /**
     * The id of the budget action.
     */
    public val actionId: Output<String>
        get() = javaResource.actionId().applyValue({ args0 -> args0 })

    /**
     * The trigger threshold of the action. See Action Threshold.
     */
    public val actionThreshold: Output<BudgetActionActionThreshold>
        get() = javaResource.actionThreshold().applyValue({ args0 ->
            args0.let({ args0 ->
                budgetActionActionThresholdToKotlin(args0)
            })
        })

    /**
     * The type of action. This defines the type of tasks that can be carried out by this action. This field also determines the format for definition. Valid values are `APPLY_IAM_POLICY`, `APPLY_SCP_POLICY`, and `RUN_SSM_DOCUMENTS`.
     */
    public val actionType: Output<String>
        get() = javaResource.actionType().applyValue({ args0 -> args0 })

    /**
     * This specifies if the action needs manual or automatic approval. Valid values are `AUTOMATIC` and `MANUAL`.
     */
    public val approvalModel: Output<String>
        get() = javaResource.approvalModel().applyValue({ args0 -> args0 })

    /**
     * The ARN of the budget action.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name of a budget.
     */
    public val budgetName: Output<String>
        get() = javaResource.budgetName().applyValue({ args0 -> args0 })

    /**
     * Specifies all of the type-specific parameters. See Definition.
     */
    public val definition: Output<BudgetActionDefinition>
        get() = javaResource.definition().applyValue({ args0 ->
            args0.let({ args0 ->
                budgetActionDefinitionToKotlin(args0)
            })
        })

    /**
     * The role passed for action execution and reversion. Roles and actions must be in the same account.
     */
    public val executionRoleArn: Output<String>
        get() = javaResource.executionRoleArn().applyValue({ args0 -> args0 })

    /**
     * The type of a notification. Valid values are `ACTUAL` or `FORECASTED`.
     */
    public val notificationType: Output<String>
        get() = javaResource.notificationType().applyValue({ args0 -> args0 })

    /**
     * The status of the budget action.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A list of subscribers. See Subscriber.
     */
    public val subscribers: Output<List<BudgetActionSubscriber>>
        get() = javaResource.subscribers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    budgetActionSubscriberToKotlin(args0)
                })
            })
        })
}

public object BudgetActionMapper : ResourceMapper<BudgetAction> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.budgets.BudgetAction::class == javaResource::class

    override fun map(javaResource: Resource): BudgetAction = BudgetAction(
        javaResource as
            com.pulumi.aws.budgets.BudgetAction,
    )
}

/**
 * @see [BudgetAction].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BudgetAction].
 */
public suspend fun budgetAction(
    name: String,
    block: suspend BudgetActionResourceBuilder.() -> Unit,
): BudgetAction {
    val builder = BudgetActionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BudgetAction].
 * @param name The _unique_ name of the resulting resource.
 */
public fun budgetAction(name: String): BudgetAction {
    val builder = BudgetActionResourceBuilder()
    builder.name(name)
    return builder.build()
}
