@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin

import com.pulumi.aws.budgets.BudgetActionArgs.builder
import com.pulumi.aws.budgets.kotlin.inputs.BudgetActionActionThresholdArgs
import com.pulumi.aws.budgets.kotlin.inputs.BudgetActionActionThresholdArgsBuilder
import com.pulumi.aws.budgets.kotlin.inputs.BudgetActionDefinitionArgs
import com.pulumi.aws.budgets.kotlin.inputs.BudgetActionDefinitionArgsBuilder
import com.pulumi.aws.budgets.kotlin.inputs.BudgetActionSubscriberArgs
import com.pulumi.aws.budgets.kotlin.inputs.BudgetActionSubscriberArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a budget action resource. Budget actions are cost savings controls that run either automatically on your behalf or by using a workflow approval process.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Policy;
 * import com.pulumi.aws.iam.PolicyArgs;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetPartitionArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.budgets.Budget;
 * import com.pulumi.aws.budgets.BudgetArgs;
 * import com.pulumi.aws.budgets.BudgetAction;
 * import com.pulumi.aws.budgets.BudgetActionArgs;
 * import com.pulumi.aws.budgets.inputs.BudgetActionActionThresholdArgs;
 * import com.pulumi.aws.budgets.inputs.BudgetActionDefinitionArgs;
 * import com.pulumi.aws.budgets.inputs.BudgetActionDefinitionIamActionDefinitionArgs;
 * import com.pulumi.aws.budgets.inputs.BudgetActionSubscriberArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("ec2:Describe*")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var examplePolicy = new Policy("examplePolicy", PolicyArgs.builder()
 *             .description("My example policy")
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         final var current = AwsFunctions.getPartition();
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers(String.format("budgets.%s", current.applyValue(getPartitionResult -> getPartitionResult.dnsSuffix())))
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleBudget = new Budget("exampleBudget", BudgetArgs.builder()
 *             .budgetType("USAGE")
 *             .limitAmount("10.0")
 *             .limitUnit("dollars")
 *             .timePeriodStart("2006-01-02_15:04")
 *             .timeUnit("MONTHLY")
 *             .build());
 *         var exampleBudgetAction = new BudgetAction("exampleBudgetAction", BudgetActionArgs.builder()
 *             .budgetName(exampleBudget.name())
 *             .actionType("APPLY_IAM_POLICY")
 *             .approvalModel("AUTOMATIC")
 *             .notificationType("ACTUAL")
 *             .executionRoleArn(exampleRole.arn())
 *             .actionThreshold(BudgetActionActionThresholdArgs.builder()
 *                 .actionThresholdType("ABSOLUTE_VALUE")
 *                 .actionThresholdValue(100)
 *                 .build())
 *             .definition(BudgetActionDefinitionArgs.builder()
 *                 .iamActionDefinition(BudgetActionDefinitionIamActionDefinitionArgs.builder()
 *                     .policyArn(examplePolicy.arn())
 *                     .roles(exampleRole.name())
 *                     .build())
 *                 .build())
 *             .subscribers(BudgetActionSubscriberArgs.builder()
 *                 .address("example@example.example")
 *                 .subscriptionType("EMAIL")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import budget actions using `AccountID:ActionID:BudgetName`. For example:
 * ```sh
 *  $ pulumi import aws:budgets/budgetAction:BudgetAction myBudget 123456789012:some-id:myBudget
 * ```
 * @property accountId The ID of the target account for budget. Will use current user's account_id by default if omitted.
 * @property actionThreshold The trigger threshold of the action. See Action Threshold.
 * @property actionType The type of action. This defines the type of tasks that can be carried out by this action. This field also determines the format for definition. Valid values are `APPLY_IAM_POLICY`, `APPLY_SCP_POLICY`, and `RUN_SSM_DOCUMENTS`.
 * @property approvalModel This specifies if the action needs manual or automatic approval. Valid values are `AUTOMATIC` and `MANUAL`.
 * @property budgetName The name of a budget.
 * @property definition Specifies all of the type-specific parameters. See Definition.
 * @property executionRoleArn The role passed for action execution and reversion. Roles and actions must be in the same account.
 * @property notificationType The type of a notification. Valid values are `ACTUAL` or `FORECASTED`.
 * @property subscribers A list of subscribers. See Subscriber.
 */
public data class BudgetActionArgs(
    public val accountId: Output<String>? = null,
    public val actionThreshold: Output<BudgetActionActionThresholdArgs>? = null,
    public val actionType: Output<String>? = null,
    public val approvalModel: Output<String>? = null,
    public val budgetName: Output<String>? = null,
    public val definition: Output<BudgetActionDefinitionArgs>? = null,
    public val executionRoleArn: Output<String>? = null,
    public val notificationType: Output<String>? = null,
    public val subscribers: Output<List<BudgetActionSubscriberArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.budgets.BudgetActionArgs> {
    override fun toJava(): com.pulumi.aws.budgets.BudgetActionArgs =
        com.pulumi.aws.budgets.BudgetActionArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .actionThreshold(actionThreshold?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .actionType(actionType?.applyValue({ args0 -> args0 }))
            .approvalModel(approvalModel?.applyValue({ args0 -> args0 }))
            .budgetName(budgetName?.applyValue({ args0 -> args0 }))
            .definition(definition?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .executionRoleArn(executionRoleArn?.applyValue({ args0 -> args0 }))
            .notificationType(notificationType?.applyValue({ args0 -> args0 }))
            .subscribers(
                subscribers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [BudgetActionArgs].
 */
@PulumiTagMarker
public class BudgetActionArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var actionThreshold: Output<BudgetActionActionThresholdArgs>? = null

    private var actionType: Output<String>? = null

    private var approvalModel: Output<String>? = null

    private var budgetName: Output<String>? = null

    private var definition: Output<BudgetActionDefinitionArgs>? = null

    private var executionRoleArn: Output<String>? = null

    private var notificationType: Output<String>? = null

    private var subscribers: Output<List<BudgetActionSubscriberArgs>>? = null

    /**
     * @param value The ID of the target account for budget. Will use current user's account_id by default if omitted.
     */
    @JvmName("vnhnfruvcmgvgicg")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value The trigger threshold of the action. See Action Threshold.
     */
    @JvmName("qlfvkqrtpeehpiwx")
    public suspend fun actionThreshold(`value`: Output<BudgetActionActionThresholdArgs>) {
        this.actionThreshold = value
    }

    /**
     * @param value The type of action. This defines the type of tasks that can be carried out by this action. This field also determines the format for definition. Valid values are `APPLY_IAM_POLICY`, `APPLY_SCP_POLICY`, and `RUN_SSM_DOCUMENTS`.
     */
    @JvmName("elrmwjlitqsufajn")
    public suspend fun actionType(`value`: Output<String>) {
        this.actionType = value
    }

    /**
     * @param value This specifies if the action needs manual or automatic approval. Valid values are `AUTOMATIC` and `MANUAL`.
     */
    @JvmName("ntqnghcicejhxtxm")
    public suspend fun approvalModel(`value`: Output<String>) {
        this.approvalModel = value
    }

    /**
     * @param value The name of a budget.
     */
    @JvmName("opyvhdvnqmqnlexb")
    public suspend fun budgetName(`value`: Output<String>) {
        this.budgetName = value
    }

    /**
     * @param value Specifies all of the type-specific parameters. See Definition.
     */
    @JvmName("neghmkxcmecuklhh")
    public suspend fun definition(`value`: Output<BudgetActionDefinitionArgs>) {
        this.definition = value
    }

    /**
     * @param value The role passed for action execution and reversion. Roles and actions must be in the same account.
     */
    @JvmName("epiccyflgqyttyvm")
    public suspend fun executionRoleArn(`value`: Output<String>) {
        this.executionRoleArn = value
    }

    /**
     * @param value The type of a notification. Valid values are `ACTUAL` or `FORECASTED`.
     */
    @JvmName("glunxduqiomksicc")
    public suspend fun notificationType(`value`: Output<String>) {
        this.notificationType = value
    }

    /**
     * @param value A list of subscribers. See Subscriber.
     */
    @JvmName("ncdfinrtcqrsueba")
    public suspend fun subscribers(`value`: Output<List<BudgetActionSubscriberArgs>>) {
        this.subscribers = value
    }

    @JvmName("qyvoiqbuveuiujjp")
    public suspend fun subscribers(vararg values: Output<BudgetActionSubscriberArgs>) {
        this.subscribers = Output.all(values.asList())
    }

    /**
     * @param values A list of subscribers. See Subscriber.
     */
    @JvmName("ifjegsjwdnrcvgpf")
    public suspend fun subscribers(values: List<Output<BudgetActionSubscriberArgs>>) {
        this.subscribers = Output.all(values)
    }

    /**
     * @param value The ID of the target account for budget. Will use current user's account_id by default if omitted.
     */
    @JvmName("bnbirimovioodhek")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value The trigger threshold of the action. See Action Threshold.
     */
    @JvmName("efgffcukaycklfam")
    public suspend fun actionThreshold(`value`: BudgetActionActionThresholdArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionThreshold = mapped
    }

    /**
     * @param argument The trigger threshold of the action. See Action Threshold.
     */
    @JvmName("atiejskabdvjmrom")
    public suspend
    fun actionThreshold(argument: suspend BudgetActionActionThresholdArgsBuilder.() -> Unit) {
        val toBeMapped = BudgetActionActionThresholdArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.actionThreshold = mapped
    }

    /**
     * @param value The type of action. This defines the type of tasks that can be carried out by this action. This field also determines the format for definition. Valid values are `APPLY_IAM_POLICY`, `APPLY_SCP_POLICY`, and `RUN_SSM_DOCUMENTS`.
     */
    @JvmName("jrautqguubjyykab")
    public suspend fun actionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionType = mapped
    }

    /**
     * @param value This specifies if the action needs manual or automatic approval. Valid values are `AUTOMATIC` and `MANUAL`.
     */
    @JvmName("ilkwcsbmwosnebva")
    public suspend fun approvalModel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.approvalModel = mapped
    }

    /**
     * @param value The name of a budget.
     */
    @JvmName("syxhfrjevprdooij")
    public suspend fun budgetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.budgetName = mapped
    }

    /**
     * @param value Specifies all of the type-specific parameters. See Definition.
     */
    @JvmName("uexydhsdgrhfiday")
    public suspend fun definition(`value`: BudgetActionDefinitionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.definition = mapped
    }

    /**
     * @param argument Specifies all of the type-specific parameters. See Definition.
     */
    @JvmName("hiwpbfsekqmaithn")
    public suspend fun definition(argument: suspend BudgetActionDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = BudgetActionDefinitionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.definition = mapped
    }

    /**
     * @param value The role passed for action execution and reversion. Roles and actions must be in the same account.
     */
    @JvmName("himpgyaoavmfnrmq")
    public suspend fun executionRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.executionRoleArn = mapped
    }

    /**
     * @param value The type of a notification. Valid values are `ACTUAL` or `FORECASTED`.
     */
    @JvmName("ktmcndcpixnitstc")
    public suspend fun notificationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationType = mapped
    }

    /**
     * @param value A list of subscribers. See Subscriber.
     */
    @JvmName("xtkpmjjlqvvbxlre")
    public suspend fun subscribers(`value`: List<BudgetActionSubscriberArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscribers = mapped
    }

    /**
     * @param argument A list of subscribers. See Subscriber.
     */
    @JvmName("cjfdbcirignmhxce")
    public suspend
    fun subscribers(argument: List<suspend BudgetActionSubscriberArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BudgetActionSubscriberArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.subscribers = mapped
    }

    /**
     * @param argument A list of subscribers. See Subscriber.
     */
    @JvmName("wioonjmejixwcvbl")
    public suspend fun subscribers(
        vararg
        argument: suspend BudgetActionSubscriberArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            BudgetActionSubscriberArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.subscribers = mapped
    }

    /**
     * @param argument A list of subscribers. See Subscriber.
     */
    @JvmName("sbhfmagdveatdgnw")
    public suspend fun subscribers(argument: suspend BudgetActionSubscriberArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(BudgetActionSubscriberArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.subscribers = mapped
    }

    /**
     * @param values A list of subscribers. See Subscriber.
     */
    @JvmName("tjpnaoxgvaiugipj")
    public suspend fun subscribers(vararg values: BudgetActionSubscriberArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subscribers = mapped
    }

    internal fun build(): BudgetActionArgs = BudgetActionArgs(
        accountId = accountId,
        actionThreshold = actionThreshold,
        actionType = actionType,
        approvalModel = approvalModel,
        budgetName = budgetName,
        definition = definition,
        executionRoleArn = executionRoleArn,
        notificationType = notificationType,
        subscribers = subscribers,
    )
}
