@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin

import com.pulumi.aws.budgets.BudgetArgs.builder
import com.pulumi.aws.budgets.kotlin.inputs.BudgetAutoAdjustDataArgs
import com.pulumi.aws.budgets.kotlin.inputs.BudgetAutoAdjustDataArgsBuilder
import com.pulumi.aws.budgets.kotlin.inputs.BudgetCostFilterArgs
import com.pulumi.aws.budgets.kotlin.inputs.BudgetCostFilterArgsBuilder
import com.pulumi.aws.budgets.kotlin.inputs.BudgetCostTypesArgs
import com.pulumi.aws.budgets.kotlin.inputs.BudgetCostTypesArgsBuilder
import com.pulumi.aws.budgets.kotlin.inputs.BudgetNotificationArgs
import com.pulumi.aws.budgets.kotlin.inputs.BudgetNotificationArgsBuilder
import com.pulumi.aws.budgets.kotlin.inputs.BudgetPlannedLimitArgs
import com.pulumi.aws.budgets.kotlin.inputs.BudgetPlannedLimitArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a budgets budget resource. Budgets use the cost visualisation provided by Cost Explorer to show you the status of your budgets, to provide forecasts of your estimated costs, and to track your AWS usage, including your free tier usage.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.budgets.Budget;
 * import com.pulumi.aws.budgets.BudgetArgs;
 * import com.pulumi.aws.budgets.inputs.BudgetCostFilterArgs;
 * import com.pulumi.aws.budgets.inputs.BudgetNotificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ec2 = new Budget("ec2", BudgetArgs.builder()
 *             .budgetType("COST")
 *             .costFilters(BudgetCostFilterArgs.builder()
 *                 .name("Service")
 *                 .values("Amazon Elastic Compute Cloud - Compute")
 *                 .build())
 *             .limitAmount("1200")
 *             .limitUnit("USD")
 *             .notifications(BudgetNotificationArgs.builder()
 *                 .comparisonOperator("GREATER_THAN")
 *                 .notificationType("FORECASTED")
 *                 .subscriberEmailAddresses("test@example.com")
 *                 .threshold(100)
 *                 .thresholdType("PERCENTAGE")
 *                 .build())
 *             .timePeriodEnd("2087-06-15_00:00")
 *             .timePeriodStart("2017-07-01_00:00")
 *             .timeUnit("MONTHLY")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import budgets using `AccountID:BudgetName`. For example:
 * ```sh
 *  $ pulumi import aws:budgets/budget:Budget myBudget 123456789012:myBudget
 * ```
 * @property accountId The ID of the target account for budget. Will use current user's account_id by default if omitted.
 * @property autoAdjustData Object containing [AutoAdjustData] which determines the budget amount for an auto-adjusting budget.
 * @property budgetType Whether this budget tracks monetary cost or usage.
 * @property costFilters A list of CostFilter name/values pair to apply to budget.
 * @property costTypes Object containing CostTypes The types of cost included in a budget, such as tax and subscriptions.
 * @property limitAmount The amount of cost or usage being measured for a budget.
 * @property limitUnit The unit of measurement used for the budget forecast, actual spend, or budget threshold, such as dollars or GB. See [Spend](http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/data-type-spend.html) documentation.
 * @property name The name of a budget. Unique within accounts.
 * @property namePrefix The prefix of the name of a budget. Unique within accounts.
 * @property notifications Object containing Budget Notifications. Can be used multiple times to define more than one budget notification.
 * @property plannedLimits Object containing Planned Budget Limits. Can be used multiple times to plan more than one budget limit. See [PlannedBudgetLimits](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_Budget.html#awscostmanagement-Type-budgets_Budget-PlannedBudgetLimits) documentation.
 * @property timePeriodEnd The end of the time period covered by the budget. There are no restrictions on the end date. Format: `2017-01-01_12:00`.
 * @property timePeriodStart The start of the time period covered by the budget. If you don't specify a start date, AWS defaults to the start of your chosen time period. The start date must come before the end date. Format: `2017-01-01_12:00`.
 * @property timeUnit The length of time until a budget resets the actual and forecasted spend. Valid values: `MONTHLY`, `QUARTERLY`, `ANNUALLY`, and `DAILY`.
 */
public data class BudgetArgs(
    public val accountId: Output<String>? = null,
    public val autoAdjustData: Output<BudgetAutoAdjustDataArgs>? = null,
    public val budgetType: Output<String>? = null,
    public val costFilters: Output<List<BudgetCostFilterArgs>>? = null,
    public val costTypes: Output<BudgetCostTypesArgs>? = null,
    public val limitAmount: Output<String>? = null,
    public val limitUnit: Output<String>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val notifications: Output<List<BudgetNotificationArgs>>? = null,
    public val plannedLimits: Output<List<BudgetPlannedLimitArgs>>? = null,
    public val timePeriodEnd: Output<String>? = null,
    public val timePeriodStart: Output<String>? = null,
    public val timeUnit: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.budgets.BudgetArgs> {
    override fun toJava(): com.pulumi.aws.budgets.BudgetArgs =
        com.pulumi.aws.budgets.BudgetArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .autoAdjustData(autoAdjustData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .budgetType(budgetType?.applyValue({ args0 -> args0 }))
            .costFilters(
                costFilters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .costTypes(costTypes?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .limitAmount(limitAmount?.applyValue({ args0 -> args0 }))
            .limitUnit(limitUnit?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .notifications(
                notifications?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .plannedLimits(
                plannedLimits?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .timePeriodEnd(timePeriodEnd?.applyValue({ args0 -> args0 }))
            .timePeriodStart(timePeriodStart?.applyValue({ args0 -> args0 }))
            .timeUnit(timeUnit?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BudgetArgs].
 */
@PulumiTagMarker
public class BudgetArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var autoAdjustData: Output<BudgetAutoAdjustDataArgs>? = null

    private var budgetType: Output<String>? = null

    private var costFilters: Output<List<BudgetCostFilterArgs>>? = null

    private var costTypes: Output<BudgetCostTypesArgs>? = null

    private var limitAmount: Output<String>? = null

    private var limitUnit: Output<String>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var notifications: Output<List<BudgetNotificationArgs>>? = null

    private var plannedLimits: Output<List<BudgetPlannedLimitArgs>>? = null

    private var timePeriodEnd: Output<String>? = null

    private var timePeriodStart: Output<String>? = null

    private var timeUnit: Output<String>? = null

    /**
     * @param value The ID of the target account for budget. Will use current user's account_id by default if omitted.
     */
    @JvmName("cutfjvdxfonarexg")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value Object containing [AutoAdjustData] which determines the budget amount for an auto-adjusting budget.
     */
    @JvmName("dfrpeqqvqrschtdq")
    public suspend fun autoAdjustData(`value`: Output<BudgetAutoAdjustDataArgs>) {
        this.autoAdjustData = value
    }

    /**
     * @param value Whether this budget tracks monetary cost or usage.
     */
    @JvmName("inybfqvqghtsrtbw")
    public suspend fun budgetType(`value`: Output<String>) {
        this.budgetType = value
    }

    /**
     * @param value A list of CostFilter name/values pair to apply to budget.
     */
    @JvmName("rvrpjivphyvfuoyq")
    public suspend fun costFilters(`value`: Output<List<BudgetCostFilterArgs>>) {
        this.costFilters = value
    }

    @JvmName("tbtpyudngintikte")
    public suspend fun costFilters(vararg values: Output<BudgetCostFilterArgs>) {
        this.costFilters = Output.all(values.asList())
    }

    /**
     * @param values A list of CostFilter name/values pair to apply to budget.
     */
    @JvmName("vlyjfafpnstelmuv")
    public suspend fun costFilters(values: List<Output<BudgetCostFilterArgs>>) {
        this.costFilters = Output.all(values)
    }

    /**
     * @param value Object containing CostTypes The types of cost included in a budget, such as tax and subscriptions.
     */
    @JvmName("cmdvjqwfsenjmekh")
    public suspend fun costTypes(`value`: Output<BudgetCostTypesArgs>) {
        this.costTypes = value
    }

    /**
     * @param value The amount of cost or usage being measured for a budget.
     */
    @JvmName("lvtgctgdfjfawuyr")
    public suspend fun limitAmount(`value`: Output<String>) {
        this.limitAmount = value
    }

    /**
     * @param value The unit of measurement used for the budget forecast, actual spend, or budget threshold, such as dollars or GB. See [Spend](http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/data-type-spend.html) documentation.
     */
    @JvmName("fjvwwbqikxhhfdet")
    public suspend fun limitUnit(`value`: Output<String>) {
        this.limitUnit = value
    }

    /**
     * @param value The name of a budget. Unique within accounts.
     */
    @JvmName("yrdwqumnkwvvhaqn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The prefix of the name of a budget. Unique within accounts.
     */
    @JvmName("oqulusxianxjleqt")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value Object containing Budget Notifications. Can be used multiple times to define more than one budget notification.
     */
    @JvmName("mdmepmfcbqrnuifi")
    public suspend fun notifications(`value`: Output<List<BudgetNotificationArgs>>) {
        this.notifications = value
    }

    @JvmName("xdiipasqwravivrf")
    public suspend fun notifications(vararg values: Output<BudgetNotificationArgs>) {
        this.notifications = Output.all(values.asList())
    }

    /**
     * @param values Object containing Budget Notifications. Can be used multiple times to define more than one budget notification.
     */
    @JvmName("wwtgshgueinieyok")
    public suspend fun notifications(values: List<Output<BudgetNotificationArgs>>) {
        this.notifications = Output.all(values)
    }

    /**
     * @param value Object containing Planned Budget Limits. Can be used multiple times to plan more than one budget limit. See [PlannedBudgetLimits](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_Budget.html#awscostmanagement-Type-budgets_Budget-PlannedBudgetLimits) documentation.
     */
    @JvmName("jjmntqhkbneimnvi")
    public suspend fun plannedLimits(`value`: Output<List<BudgetPlannedLimitArgs>>) {
        this.plannedLimits = value
    }

    @JvmName("vdeuxyjdqbxvxeal")
    public suspend fun plannedLimits(vararg values: Output<BudgetPlannedLimitArgs>) {
        this.plannedLimits = Output.all(values.asList())
    }

    /**
     * @param values Object containing Planned Budget Limits. Can be used multiple times to plan more than one budget limit. See [PlannedBudgetLimits](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_Budget.html#awscostmanagement-Type-budgets_Budget-PlannedBudgetLimits) documentation.
     */
    @JvmName("kgyuisaeflrpkyav")
    public suspend fun plannedLimits(values: List<Output<BudgetPlannedLimitArgs>>) {
        this.plannedLimits = Output.all(values)
    }

    /**
     * @param value The end of the time period covered by the budget. There are no restrictions on the end date. Format: `2017-01-01_12:00`.
     */
    @JvmName("jmphqbekungbhmem")
    public suspend fun timePeriodEnd(`value`: Output<String>) {
        this.timePeriodEnd = value
    }

    /**
     * @param value The start of the time period covered by the budget. If you don't specify a start date, AWS defaults to the start of your chosen time period. The start date must come before the end date. Format: `2017-01-01_12:00`.
     */
    @JvmName("rkdsbvaqfendskta")
    public suspend fun timePeriodStart(`value`: Output<String>) {
        this.timePeriodStart = value
    }

    /**
     * @param value The length of time until a budget resets the actual and forecasted spend. Valid values: `MONTHLY`, `QUARTERLY`, `ANNUALLY`, and `DAILY`.
     */
    @JvmName("lhsttxgjcgicgtcc")
    public suspend fun timeUnit(`value`: Output<String>) {
        this.timeUnit = value
    }

    /**
     * @param value The ID of the target account for budget. Will use current user's account_id by default if omitted.
     */
    @JvmName("ichaulunxfvrtovx")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value Object containing [AutoAdjustData] which determines the budget amount for an auto-adjusting budget.
     */
    @JvmName("eagpknhvnxbjkiwp")
    public suspend fun autoAdjustData(`value`: BudgetAutoAdjustDataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoAdjustData = mapped
    }

    /**
     * @param argument Object containing [AutoAdjustData] which determines the budget amount for an auto-adjusting budget.
     */
    @JvmName("muhktkdpphehsykb")
    public suspend fun autoAdjustData(argument: suspend BudgetAutoAdjustDataArgsBuilder.() -> Unit) {
        val toBeMapped = BudgetAutoAdjustDataArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.autoAdjustData = mapped
    }

    /**
     * @param value Whether this budget tracks monetary cost or usage.
     */
    @JvmName("libyctnfqqfbxkuu")
    public suspend fun budgetType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.budgetType = mapped
    }

    /**
     * @param value A list of CostFilter name/values pair to apply to budget.
     */
    @JvmName("puaxkvhybbbsnxdy")
    public suspend fun costFilters(`value`: List<BudgetCostFilterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.costFilters = mapped
    }

    /**
     * @param argument A list of CostFilter name/values pair to apply to budget.
     */
    @JvmName("qpumaihrpxymiljg")
    public suspend fun costFilters(argument: List<suspend BudgetCostFilterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BudgetCostFilterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.costFilters = mapped
    }

    /**
     * @param argument A list of CostFilter name/values pair to apply to budget.
     */
    @JvmName("ovsuhgnbvkabuhvg")
    public suspend fun costFilters(vararg argument: suspend BudgetCostFilterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BudgetCostFilterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.costFilters = mapped
    }

    /**
     * @param argument A list of CostFilter name/values pair to apply to budget.
     */
    @JvmName("uwmmngkwtuddbgfd")
    public suspend fun costFilters(argument: suspend BudgetCostFilterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(BudgetCostFilterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.costFilters = mapped
    }

    /**
     * @param values A list of CostFilter name/values pair to apply to budget.
     */
    @JvmName("jhwwwgtpemwcsktb")
    public suspend fun costFilters(vararg values: BudgetCostFilterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.costFilters = mapped
    }

    /**
     * @param value Object containing CostTypes The types of cost included in a budget, such as tax and subscriptions.
     */
    @JvmName("kcvliooivpppfhax")
    public suspend fun costTypes(`value`: BudgetCostTypesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.costTypes = mapped
    }

    /**
     * @param argument Object containing CostTypes The types of cost included in a budget, such as tax and subscriptions.
     */
    @JvmName("qdbjuukcxpaakrud")
    public suspend fun costTypes(argument: suspend BudgetCostTypesArgsBuilder.() -> Unit) {
        val toBeMapped = BudgetCostTypesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.costTypes = mapped
    }

    /**
     * @param value The amount of cost or usage being measured for a budget.
     */
    @JvmName("evbbxdgbtcnolowc")
    public suspend fun limitAmount(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.limitAmount = mapped
    }

    /**
     * @param value The unit of measurement used for the budget forecast, actual spend, or budget threshold, such as dollars or GB. See [Spend](http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/data-type-spend.html) documentation.
     */
    @JvmName("kxffgiugvuyntftd")
    public suspend fun limitUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.limitUnit = mapped
    }

    /**
     * @param value The name of a budget. Unique within accounts.
     */
    @JvmName("udheuhxyuknygfbg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The prefix of the name of a budget. Unique within accounts.
     */
    @JvmName("kensbpyjoaogtixp")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value Object containing Budget Notifications. Can be used multiple times to define more than one budget notification.
     */
    @JvmName("lugdolbvuclrjmxf")
    public suspend fun notifications(`value`: List<BudgetNotificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notifications = mapped
    }

    /**
     * @param argument Object containing Budget Notifications. Can be used multiple times to define more than one budget notification.
     */
    @JvmName("joqooufytfhxliky")
    public suspend
    fun notifications(argument: List<suspend BudgetNotificationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BudgetNotificationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.notifications = mapped
    }

    /**
     * @param argument Object containing Budget Notifications. Can be used multiple times to define more than one budget notification.
     */
    @JvmName("pgowqmkaqquartyy")
    public suspend fun notifications(
        vararg
        argument: suspend BudgetNotificationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            BudgetNotificationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.notifications = mapped
    }

    /**
     * @param argument Object containing Budget Notifications. Can be used multiple times to define more than one budget notification.
     */
    @JvmName("esvpqmmpfywbsyel")
    public suspend fun notifications(argument: suspend BudgetNotificationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(BudgetNotificationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.notifications = mapped
    }

    /**
     * @param values Object containing Budget Notifications. Can be used multiple times to define more than one budget notification.
     */
    @JvmName("cwsrrqupqrnyjyta")
    public suspend fun notifications(vararg values: BudgetNotificationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notifications = mapped
    }

    /**
     * @param value Object containing Planned Budget Limits. Can be used multiple times to plan more than one budget limit. See [PlannedBudgetLimits](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_Budget.html#awscostmanagement-Type-budgets_Budget-PlannedBudgetLimits) documentation.
     */
    @JvmName("adlqowmbucidtxpr")
    public suspend fun plannedLimits(`value`: List<BudgetPlannedLimitArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plannedLimits = mapped
    }

    /**
     * @param argument Object containing Planned Budget Limits. Can be used multiple times to plan more than one budget limit. See [PlannedBudgetLimits](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_Budget.html#awscostmanagement-Type-budgets_Budget-PlannedBudgetLimits) documentation.
     */
    @JvmName("qxaduajthfdgcehr")
    public suspend
    fun plannedLimits(argument: List<suspend BudgetPlannedLimitArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BudgetPlannedLimitArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.plannedLimits = mapped
    }

    /**
     * @param argument Object containing Planned Budget Limits. Can be used multiple times to plan more than one budget limit. See [PlannedBudgetLimits](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_Budget.html#awscostmanagement-Type-budgets_Budget-PlannedBudgetLimits) documentation.
     */
    @JvmName("uvecaarheqghlebc")
    public suspend fun plannedLimits(
        vararg
        argument: suspend BudgetPlannedLimitArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            BudgetPlannedLimitArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.plannedLimits = mapped
    }

    /**
     * @param argument Object containing Planned Budget Limits. Can be used multiple times to plan more than one budget limit. See [PlannedBudgetLimits](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_Budget.html#awscostmanagement-Type-budgets_Budget-PlannedBudgetLimits) documentation.
     */
    @JvmName("wyhugmgkrjepvhhg")
    public suspend fun plannedLimits(argument: suspend BudgetPlannedLimitArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(BudgetPlannedLimitArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.plannedLimits = mapped
    }

    /**
     * @param values Object containing Planned Budget Limits. Can be used multiple times to plan more than one budget limit. See [PlannedBudgetLimits](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_Budget.html#awscostmanagement-Type-budgets_Budget-PlannedBudgetLimits) documentation.
     */
    @JvmName("rtqqksextupmhdcq")
    public suspend fun plannedLimits(vararg values: BudgetPlannedLimitArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.plannedLimits = mapped
    }

    /**
     * @param value The end of the time period covered by the budget. There are no restrictions on the end date. Format: `2017-01-01_12:00`.
     */
    @JvmName("trplpyvgxhtcxtit")
    public suspend fun timePeriodEnd(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timePeriodEnd = mapped
    }

    /**
     * @param value The start of the time period covered by the budget. If you don't specify a start date, AWS defaults to the start of your chosen time period. The start date must come before the end date. Format: `2017-01-01_12:00`.
     */
    @JvmName("xlhtwfywpsoxdhbs")
    public suspend fun timePeriodStart(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timePeriodStart = mapped
    }

    /**
     * @param value The length of time until a budget resets the actual and forecasted spend. Valid values: `MONTHLY`, `QUARTERLY`, `ANNUALLY`, and `DAILY`.
     */
    @JvmName("wpnrylurgkliiqcw")
    public suspend fun timeUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeUnit = mapped
    }

    internal fun build(): BudgetArgs = BudgetArgs(
        accountId = accountId,
        autoAdjustData = autoAdjustData,
        budgetType = budgetType,
        costFilters = costFilters,
        costTypes = costTypes,
        limitAmount = limitAmount,
        limitUnit = limitUnit,
        name = name,
        namePrefix = namePrefix,
        notifications = notifications,
        plannedLimits = plannedLimits,
        timePeriodEnd = timePeriodEnd,
        timePeriodStart = timePeriodStart,
        timeUnit = timeUnit,
    )
}
