@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin

import com.pulumi.aws.budgets.BudgetsFunctions.getBudgetPlain
import com.pulumi.aws.budgets.kotlin.inputs.GetBudgetPlainArgs
import com.pulumi.aws.budgets.kotlin.inputs.GetBudgetPlainArgsBuilder
import com.pulumi.aws.budgets.kotlin.outputs.GetBudgetResult
import com.pulumi.aws.budgets.kotlin.outputs.GetBudgetResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object BudgetsFunctions {
    /**
     * Data source for managing an AWS Web Services Budgets Budget.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.budgets.BudgetsFunctions;
     * import com.pulumi.aws.budgets.inputs.GetBudgetArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = BudgetsFunctions.getBudget(GetBudgetArgs.builder()
     *             .name(aws_budgets_budget.test().name())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getBudget.
     * @return A collection of values returned by getBudget.
     */
    public suspend fun getBudget(argument: GetBudgetPlainArgs): GetBudgetResult =
        toKotlin(getBudgetPlain(argument.toJava()).await())

    /**
     * @see [getBudget].
     * @param accountId The ID of the target account for budget. Will use current user's account_id by default if omitted.
     * @param name The name of a budget. Unique within accounts.
     * The following arguments are optional:
     * @param namePrefix The prefix of the name of a budget. Unique within accounts.
     * @return A collection of values returned by getBudget.
     */
    public suspend fun getBudget(
        accountId: String? = null,
        name: String,
        namePrefix: String? = null,
    ): GetBudgetResult {
        val argument = GetBudgetPlainArgs(
            accountId = accountId,
            name = name,
            namePrefix = namePrefix,
        )
        return toKotlin(getBudgetPlain(argument.toJava()).await())
    }

    /**
     * @see [getBudget].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;budgets&#46;kotlin&#46;inputs&#46;GetBudgetPlainArgs].
     * @return A collection of values returned by getBudget.
     */
    public suspend fun getBudget(argument: suspend GetBudgetPlainArgsBuilder.() -> Unit):
        GetBudgetResult {
        val builder = GetBudgetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getBudgetPlain(builtArgument.toJava()).await())
    }
}
