@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin.inputs

import com.pulumi.aws.budgets.inputs.BudgetActionDefinitionIamActionDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property groups A list of groups to be attached. There must be at least one group.
 * @property policyArn The Amazon Resource Name (ARN) of the policy to be attached.
 * @property roles A list of roles to be attached. There must be at least one role.
 * @property users A list of users to be attached. There must be at least one user.
 */
public data class BudgetActionDefinitionIamActionDefinitionArgs(
    public val groups: Output<List<String>>? = null,
    public val policyArn: Output<String>,
    public val roles: Output<List<String>>? = null,
    public val users: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.budgets.inputs.BudgetActionDefinitionIamActionDefinitionArgs> {
    override fun toJava(): com.pulumi.aws.budgets.inputs.BudgetActionDefinitionIamActionDefinitionArgs =
        com.pulumi.aws.budgets.inputs.BudgetActionDefinitionIamActionDefinitionArgs.builder()
            .groups(groups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .policyArn(policyArn.applyValue({ args0 -> args0 }))
            .roles(roles?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .users(users?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [BudgetActionDefinitionIamActionDefinitionArgs].
 */
@PulumiTagMarker
public class BudgetActionDefinitionIamActionDefinitionArgsBuilder internal constructor() {
    private var groups: Output<List<String>>? = null

    private var policyArn: Output<String>? = null

    private var roles: Output<List<String>>? = null

    private var users: Output<List<String>>? = null

    /**
     * @param value A list of groups to be attached. There must be at least one group.
     */
    @JvmName("wnjyneqexoibcuqe")
    public suspend fun groups(`value`: Output<List<String>>) {
        this.groups = value
    }

    @JvmName("fbxrfcpuaidngqti")
    public suspend fun groups(vararg values: Output<String>) {
        this.groups = Output.all(values.asList())
    }

    /**
     * @param values A list of groups to be attached. There must be at least one group.
     */
    @JvmName("cqjvmcsjgbvpxkaw")
    public suspend fun groups(values: List<Output<String>>) {
        this.groups = Output.all(values)
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the policy to be attached.
     */
    @JvmName("aqbvmhwndemwchxq")
    public suspend fun policyArn(`value`: Output<String>) {
        this.policyArn = value
    }

    /**
     * @param value A list of roles to be attached. There must be at least one role.
     */
    @JvmName("recgxfhuvxmhyssy")
    public suspend fun roles(`value`: Output<List<String>>) {
        this.roles = value
    }

    @JvmName("gbmxbrrowokegmlc")
    public suspend fun roles(vararg values: Output<String>) {
        this.roles = Output.all(values.asList())
    }

    /**
     * @param values A list of roles to be attached. There must be at least one role.
     */
    @JvmName("rnbvhrpjhrrkbvnt")
    public suspend fun roles(values: List<Output<String>>) {
        this.roles = Output.all(values)
    }

    /**
     * @param value A list of users to be attached. There must be at least one user.
     */
    @JvmName("kpjpfveiwybqnbvh")
    public suspend fun users(`value`: Output<List<String>>) {
        this.users = value
    }

    @JvmName("tpqelnebibrckixq")
    public suspend fun users(vararg values: Output<String>) {
        this.users = Output.all(values.asList())
    }

    /**
     * @param values A list of users to be attached. There must be at least one user.
     */
    @JvmName("mvggxrhmxbiafdwv")
    public suspend fun users(values: List<Output<String>>) {
        this.users = Output.all(values)
    }

    /**
     * @param value A list of groups to be attached. There must be at least one group.
     */
    @JvmName("vastdgxjkyoujloe")
    public suspend fun groups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groups = mapped
    }

    /**
     * @param values A list of groups to be attached. There must be at least one group.
     */
    @JvmName("yjafbatpakijavmh")
    public suspend fun groups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groups = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the policy to be attached.
     */
    @JvmName("rjkihijqoktgbbba")
    public suspend fun policyArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyArn = mapped
    }

    /**
     * @param value A list of roles to be attached. There must be at least one role.
     */
    @JvmName("fnaqdflglxcqkqyf")
    public suspend fun roles(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    /**
     * @param values A list of roles to be attached. There must be at least one role.
     */
    @JvmName("yoaqqhompaeflwwe")
    public suspend fun roles(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    /**
     * @param value A list of users to be attached. There must be at least one user.
     */
    @JvmName("lrebbokngixndobx")
    public suspend fun users(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.users = mapped
    }

    /**
     * @param values A list of users to be attached. There must be at least one user.
     */
    @JvmName("rdioabgakebcgsgh")
    public suspend fun users(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.users = mapped
    }

    internal fun build(): BudgetActionDefinitionIamActionDefinitionArgs =
        BudgetActionDefinitionIamActionDefinitionArgs(
            groups = groups,
            policyArn = policyArn ?: throw PulumiNullFieldException("policyArn"),
            roles = roles,
            users = users,
        )
}
