@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin.inputs

import com.pulumi.aws.budgets.inputs.BudgetActionDefinitionScpActionDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property policyId The policy ID attached.
 * @property targetIds A list of target IDs.
 */
public data class BudgetActionDefinitionScpActionDefinitionArgs(
    public val policyId: Output<String>,
    public val targetIds: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.budgets.inputs.BudgetActionDefinitionScpActionDefinitionArgs> {
    override fun toJava(): com.pulumi.aws.budgets.inputs.BudgetActionDefinitionScpActionDefinitionArgs =
        com.pulumi.aws.budgets.inputs.BudgetActionDefinitionScpActionDefinitionArgs.builder()
            .policyId(policyId.applyValue({ args0 -> args0 }))
            .targetIds(targetIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [BudgetActionDefinitionScpActionDefinitionArgs].
 */
@PulumiTagMarker
public class BudgetActionDefinitionScpActionDefinitionArgsBuilder internal constructor() {
    private var policyId: Output<String>? = null

    private var targetIds: Output<List<String>>? = null

    /**
     * @param value The policy ID attached.
     */
    @JvmName("xluinsergehstyxp")
    public suspend fun policyId(`value`: Output<String>) {
        this.policyId = value
    }

    /**
     * @param value A list of target IDs.
     */
    @JvmName("phswbqeitjwbpkuf")
    public suspend fun targetIds(`value`: Output<List<String>>) {
        this.targetIds = value
    }

    @JvmName("tudftbyqitqbmven")
    public suspend fun targetIds(vararg values: Output<String>) {
        this.targetIds = Output.all(values.asList())
    }

    /**
     * @param values A list of target IDs.
     */
    @JvmName("bcuddfwamynuyfye")
    public suspend fun targetIds(values: List<Output<String>>) {
        this.targetIds = Output.all(values)
    }

    /**
     * @param value The policy ID attached.
     */
    @JvmName("ndhqlmvxjlifuomv")
    public suspend fun policyId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyId = mapped
    }

    /**
     * @param value A list of target IDs.
     */
    @JvmName("hsonlbbguvkfjxho")
    public suspend fun targetIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetIds = mapped
    }

    /**
     * @param values A list of target IDs.
     */
    @JvmName("gvftalvsuxrtswjm")
    public suspend fun targetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetIds = mapped
    }

    internal fun build(): BudgetActionDefinitionScpActionDefinitionArgs =
        BudgetActionDefinitionScpActionDefinitionArgs(
            policyId = policyId ?: throw PulumiNullFieldException("policyId"),
            targetIds = targetIds ?: throw PulumiNullFieldException("targetIds"),
        )
}
