@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin.inputs

import com.pulumi.aws.budgets.inputs.BudgetActionDefinitionSsmActionDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property actionSubType The action subType. Valid values are `STOP_EC2_INSTANCES` or `STOP_RDS_INSTANCES`.
 * @property instanceIds The EC2 and RDS instance IDs.
 * @property region The Region to run the SSM document.
 */
public data class BudgetActionDefinitionSsmActionDefinitionArgs(
    public val actionSubType: Output<String>,
    public val instanceIds: Output<List<String>>,
    public val region: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.budgets.inputs.BudgetActionDefinitionSsmActionDefinitionArgs> {
    override fun toJava(): com.pulumi.aws.budgets.inputs.BudgetActionDefinitionSsmActionDefinitionArgs =
        com.pulumi.aws.budgets.inputs.BudgetActionDefinitionSsmActionDefinitionArgs.builder()
            .actionSubType(actionSubType.applyValue({ args0 -> args0 }))
            .instanceIds(instanceIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .region(region.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BudgetActionDefinitionSsmActionDefinitionArgs].
 */
@PulumiTagMarker
public class BudgetActionDefinitionSsmActionDefinitionArgsBuilder internal constructor() {
    private var actionSubType: Output<String>? = null

    private var instanceIds: Output<List<String>>? = null

    private var region: Output<String>? = null

    /**
     * @param value The action subType. Valid values are `STOP_EC2_INSTANCES` or `STOP_RDS_INSTANCES`.
     */
    @JvmName("aufhdvjbaltxvrfq")
    public suspend fun actionSubType(`value`: Output<String>) {
        this.actionSubType = value
    }

    /**
     * @param value The EC2 and RDS instance IDs.
     */
    @JvmName("ayeprqqtsqmcerjn")
    public suspend fun instanceIds(`value`: Output<List<String>>) {
        this.instanceIds = value
    }

    @JvmName("pitvdbvsqaanuxbo")
    public suspend fun instanceIds(vararg values: Output<String>) {
        this.instanceIds = Output.all(values.asList())
    }

    /**
     * @param values The EC2 and RDS instance IDs.
     */
    @JvmName("sgbvvsbacmlrepas")
    public suspend fun instanceIds(values: List<Output<String>>) {
        this.instanceIds = Output.all(values)
    }

    /**
     * @param value The Region to run the SSM document.
     */
    @JvmName("ugqqyykgshpnxlni")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value The action subType. Valid values are `STOP_EC2_INSTANCES` or `STOP_RDS_INSTANCES`.
     */
    @JvmName("crbxfiuaacvdotdu")
    public suspend fun actionSubType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionSubType = mapped
    }

    /**
     * @param value The EC2 and RDS instance IDs.
     */
    @JvmName("nqpmjhefmwqjhenr")
    public suspend fun instanceIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceIds = mapped
    }

    /**
     * @param values The EC2 and RDS instance IDs.
     */
    @JvmName("whvrgwtaotdgyxmm")
    public suspend fun instanceIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceIds = mapped
    }

    /**
     * @param value The Region to run the SSM document.
     */
    @JvmName("txffblwuksfbjrtn")
    public suspend fun region(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.region = mapped
    }

    internal fun build(): BudgetActionDefinitionSsmActionDefinitionArgs =
        BudgetActionDefinitionSsmActionDefinitionArgs(
            actionSubType = actionSubType ?: throw PulumiNullFieldException("actionSubType"),
            instanceIds = instanceIds ?: throw PulumiNullFieldException("instanceIds"),
            region = region ?: throw PulumiNullFieldException("region"),
        )
}
