@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin.inputs

import com.pulumi.aws.budgets.inputs.BudgetAutoAdjustDataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property autoAdjustType
 * @property historicalOptions
 * @property lastAutoAdjustTime
 */
public data class BudgetAutoAdjustDataArgs(
    public val autoAdjustType: Output<String>,
    public val historicalOptions: Output<BudgetAutoAdjustDataHistoricalOptionsArgs>? = null,
    public val lastAutoAdjustTime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.budgets.inputs.BudgetAutoAdjustDataArgs> {
    override fun toJava(): com.pulumi.aws.budgets.inputs.BudgetAutoAdjustDataArgs =
        com.pulumi.aws.budgets.inputs.BudgetAutoAdjustDataArgs.builder()
            .autoAdjustType(autoAdjustType.applyValue({ args0 -> args0 }))
            .historicalOptions(historicalOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .lastAutoAdjustTime(lastAutoAdjustTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BudgetAutoAdjustDataArgs].
 */
@PulumiTagMarker
public class BudgetAutoAdjustDataArgsBuilder internal constructor() {
    private var autoAdjustType: Output<String>? = null

    private var historicalOptions: Output<BudgetAutoAdjustDataHistoricalOptionsArgs>? = null

    private var lastAutoAdjustTime: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("eswuoqoyybxrrhtx")
    public suspend fun autoAdjustType(`value`: Output<String>) {
        this.autoAdjustType = value
    }

    /**
     * @param value
     */
    @JvmName("pkqdntjeieslgpay")
    public suspend fun historicalOptions(`value`: Output<BudgetAutoAdjustDataHistoricalOptionsArgs>) {
        this.historicalOptions = value
    }

    /**
     * @param value
     */
    @JvmName("xtyiprmkvgqgbsip")
    public suspend fun lastAutoAdjustTime(`value`: Output<String>) {
        this.lastAutoAdjustTime = value
    }

    /**
     * @param value
     */
    @JvmName("vmdnbmatbkhjhjng")
    public suspend fun autoAdjustType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoAdjustType = mapped
    }

    /**
     * @param value
     */
    @JvmName("mlakhnoaeqwsesjp")
    public suspend fun historicalOptions(`value`: BudgetAutoAdjustDataHistoricalOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.historicalOptions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("enjkuainngbtbqqf")
    public suspend
    fun historicalOptions(argument: suspend BudgetAutoAdjustDataHistoricalOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = BudgetAutoAdjustDataHistoricalOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.historicalOptions = mapped
    }

    /**
     * @param value
     */
    @JvmName("fqbkslksgmxxcywg")
    public suspend fun lastAutoAdjustTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastAutoAdjustTime = mapped
    }

    internal fun build(): BudgetAutoAdjustDataArgs = BudgetAutoAdjustDataArgs(
        autoAdjustType = autoAdjustType ?: throw PulumiNullFieldException("autoAdjustType"),
        historicalOptions = historicalOptions,
        lastAutoAdjustTime = lastAutoAdjustTime,
    )
}
