@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin.inputs

import com.pulumi.aws.budgets.inputs.BudgetAutoAdjustDataHistoricalOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property budgetAdjustmentPeriod
 * @property lookbackAvailablePeriods
 */
public data class BudgetAutoAdjustDataHistoricalOptionsArgs(
    public val budgetAdjustmentPeriod: Output<Int>,
    public val lookbackAvailablePeriods: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.budgets.inputs.BudgetAutoAdjustDataHistoricalOptionsArgs> {
    override fun toJava(): com.pulumi.aws.budgets.inputs.BudgetAutoAdjustDataHistoricalOptionsArgs =
        com.pulumi.aws.budgets.inputs.BudgetAutoAdjustDataHistoricalOptionsArgs.builder()
            .budgetAdjustmentPeriod(budgetAdjustmentPeriod.applyValue({ args0 -> args0 }))
            .lookbackAvailablePeriods(lookbackAvailablePeriods?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BudgetAutoAdjustDataHistoricalOptionsArgs].
 */
@PulumiTagMarker
public class BudgetAutoAdjustDataHistoricalOptionsArgsBuilder internal constructor() {
    private var budgetAdjustmentPeriod: Output<Int>? = null

    private var lookbackAvailablePeriods: Output<Int>? = null

    /**
     * @param value
     */
    @JvmName("fjditskjknuqtqbc")
    public suspend fun budgetAdjustmentPeriod(`value`: Output<Int>) {
        this.budgetAdjustmentPeriod = value
    }

    /**
     * @param value
     */
    @JvmName("kfqbiddiayftfyqc")
    public suspend fun lookbackAvailablePeriods(`value`: Output<Int>) {
        this.lookbackAvailablePeriods = value
    }

    /**
     * @param value
     */
    @JvmName("ivensojyfgeoolcy")
    public suspend fun budgetAdjustmentPeriod(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.budgetAdjustmentPeriod = mapped
    }

    /**
     * @param value
     */
    @JvmName("inweunhxeyjgsjuh")
    public suspend fun lookbackAvailablePeriods(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lookbackAvailablePeriods = mapped
    }

    internal fun build(): BudgetAutoAdjustDataHistoricalOptionsArgs =
        BudgetAutoAdjustDataHistoricalOptionsArgs(
            budgetAdjustmentPeriod = budgetAdjustmentPeriod ?: throw
                PulumiNullFieldException("budgetAdjustmentPeriod"),
            lookbackAvailablePeriods = lookbackAvailablePeriods,
        )
}
