@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin.inputs

import com.pulumi.aws.budgets.inputs.BudgetCostTypesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property includeCredit A boolean value whether to include credits in the cost budget. Defaults to `true`
 * @property includeDiscount Whether a budget includes discounts. Defaults to `true`
 * @property includeOtherSubscription A boolean value whether to include other subscription costs in the cost budget. Defaults to `true`
 * @property includeRecurring A boolean value whether to include recurring costs in the cost budget. Defaults to `true`
 * @property includeRefund A boolean value whether to include refunds in the cost budget. Defaults to `true`
 * @property includeSubscription A boolean value whether to include subscriptions in the cost budget. Defaults to `true`
 * @property includeSupport A boolean value whether to include support costs in the cost budget. Defaults to `true`
 * @property includeTax A boolean value whether to include tax in the cost budget. Defaults to `true`
 * @property includeUpfront A boolean value whether to include upfront costs in the cost budget. Defaults to `true`
 * @property useAmortized Whether a budget uses the amortized rate. Defaults to `false`
 * @property useBlended A boolean value whether to use blended costs in the cost budget. Defaults to `false`
 */
public data class BudgetCostTypesArgs(
    public val includeCredit: Output<Boolean>? = null,
    public val includeDiscount: Output<Boolean>? = null,
    public val includeOtherSubscription: Output<Boolean>? = null,
    public val includeRecurring: Output<Boolean>? = null,
    public val includeRefund: Output<Boolean>? = null,
    public val includeSubscription: Output<Boolean>? = null,
    public val includeSupport: Output<Boolean>? = null,
    public val includeTax: Output<Boolean>? = null,
    public val includeUpfront: Output<Boolean>? = null,
    public val useAmortized: Output<Boolean>? = null,
    public val useBlended: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.budgets.inputs.BudgetCostTypesArgs> {
    override fun toJava(): com.pulumi.aws.budgets.inputs.BudgetCostTypesArgs =
        com.pulumi.aws.budgets.inputs.BudgetCostTypesArgs.builder()
            .includeCredit(includeCredit?.applyValue({ args0 -> args0 }))
            .includeDiscount(includeDiscount?.applyValue({ args0 -> args0 }))
            .includeOtherSubscription(includeOtherSubscription?.applyValue({ args0 -> args0 }))
            .includeRecurring(includeRecurring?.applyValue({ args0 -> args0 }))
            .includeRefund(includeRefund?.applyValue({ args0 -> args0 }))
            .includeSubscription(includeSubscription?.applyValue({ args0 -> args0 }))
            .includeSupport(includeSupport?.applyValue({ args0 -> args0 }))
            .includeTax(includeTax?.applyValue({ args0 -> args0 }))
            .includeUpfront(includeUpfront?.applyValue({ args0 -> args0 }))
            .useAmortized(useAmortized?.applyValue({ args0 -> args0 }))
            .useBlended(useBlended?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BudgetCostTypesArgs].
 */
@PulumiTagMarker
public class BudgetCostTypesArgsBuilder internal constructor() {
    private var includeCredit: Output<Boolean>? = null

    private var includeDiscount: Output<Boolean>? = null

    private var includeOtherSubscription: Output<Boolean>? = null

    private var includeRecurring: Output<Boolean>? = null

    private var includeRefund: Output<Boolean>? = null

    private var includeSubscription: Output<Boolean>? = null

    private var includeSupport: Output<Boolean>? = null

    private var includeTax: Output<Boolean>? = null

    private var includeUpfront: Output<Boolean>? = null

    private var useAmortized: Output<Boolean>? = null

    private var useBlended: Output<Boolean>? = null

    /**
     * @param value A boolean value whether to include credits in the cost budget. Defaults to `true`
     */
    @JvmName("vreuuxnilbdnqghn")
    public suspend fun includeCredit(`value`: Output<Boolean>) {
        this.includeCredit = value
    }

    /**
     * @param value Whether a budget includes discounts. Defaults to `true`
     */
    @JvmName("kfggqljpddylbqef")
    public suspend fun includeDiscount(`value`: Output<Boolean>) {
        this.includeDiscount = value
    }

    /**
     * @param value A boolean value whether to include other subscription costs in the cost budget. Defaults to `true`
     */
    @JvmName("nfarfcrrwjwhqrlg")
    public suspend fun includeOtherSubscription(`value`: Output<Boolean>) {
        this.includeOtherSubscription = value
    }

    /**
     * @param value A boolean value whether to include recurring costs in the cost budget. Defaults to `true`
     */
    @JvmName("flslmnytvqjihuhf")
    public suspend fun includeRecurring(`value`: Output<Boolean>) {
        this.includeRecurring = value
    }

    /**
     * @param value A boolean value whether to include refunds in the cost budget. Defaults to `true`
     */
    @JvmName("dapmofgfcuoagmpt")
    public suspend fun includeRefund(`value`: Output<Boolean>) {
        this.includeRefund = value
    }

    /**
     * @param value A boolean value whether to include subscriptions in the cost budget. Defaults to `true`
     */
    @JvmName("atkxmhwxkbpqjjer")
    public suspend fun includeSubscription(`value`: Output<Boolean>) {
        this.includeSubscription = value
    }

    /**
     * @param value A boolean value whether to include support costs in the cost budget. Defaults to `true`
     */
    @JvmName("peaxjaoebeikojrf")
    public suspend fun includeSupport(`value`: Output<Boolean>) {
        this.includeSupport = value
    }

    /**
     * @param value A boolean value whether to include tax in the cost budget. Defaults to `true`
     */
    @JvmName("hqedtaotbrrpmkkp")
    public suspend fun includeTax(`value`: Output<Boolean>) {
        this.includeTax = value
    }

    /**
     * @param value A boolean value whether to include upfront costs in the cost budget. Defaults to `true`
     */
    @JvmName("yorbfwfnbrsxddwf")
    public suspend fun includeUpfront(`value`: Output<Boolean>) {
        this.includeUpfront = value
    }

    /**
     * @param value Whether a budget uses the amortized rate. Defaults to `false`
     */
    @JvmName("hlynskambhkmfxlb")
    public suspend fun useAmortized(`value`: Output<Boolean>) {
        this.useAmortized = value
    }

    /**
     * @param value A boolean value whether to use blended costs in the cost budget. Defaults to `false`
     */
    @JvmName("yjbcpubygauagkpr")
    public suspend fun useBlended(`value`: Output<Boolean>) {
        this.useBlended = value
    }

    /**
     * @param value A boolean value whether to include credits in the cost budget. Defaults to `true`
     */
    @JvmName("umolsdkaqqopdpjk")
    public suspend fun includeCredit(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeCredit = mapped
    }

    /**
     * @param value Whether a budget includes discounts. Defaults to `true`
     */
    @JvmName("mmgiuuinyjnvwthh")
    public suspend fun includeDiscount(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeDiscount = mapped
    }

    /**
     * @param value A boolean value whether to include other subscription costs in the cost budget. Defaults to `true`
     */
    @JvmName("hprwavprpffrqubd")
    public suspend fun includeOtherSubscription(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeOtherSubscription = mapped
    }

    /**
     * @param value A boolean value whether to include recurring costs in the cost budget. Defaults to `true`
     */
    @JvmName("kllaamovccyhjyjx")
    public suspend fun includeRecurring(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeRecurring = mapped
    }

    /**
     * @param value A boolean value whether to include refunds in the cost budget. Defaults to `true`
     */
    @JvmName("xbhnvaesqrmpvdey")
    public suspend fun includeRefund(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeRefund = mapped
    }

    /**
     * @param value A boolean value whether to include subscriptions in the cost budget. Defaults to `true`
     */
    @JvmName("nwubuofhkyyisgnh")
    public suspend fun includeSubscription(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeSubscription = mapped
    }

    /**
     * @param value A boolean value whether to include support costs in the cost budget. Defaults to `true`
     */
    @JvmName("efqwlwsjkjridgum")
    public suspend fun includeSupport(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeSupport = mapped
    }

    /**
     * @param value A boolean value whether to include tax in the cost budget. Defaults to `true`
     */
    @JvmName("kdxmjdevtejucvtv")
    public suspend fun includeTax(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeTax = mapped
    }

    /**
     * @param value A boolean value whether to include upfront costs in the cost budget. Defaults to `true`
     */
    @JvmName("nsyflnfegiwovhvs")
    public suspend fun includeUpfront(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeUpfront = mapped
    }

    /**
     * @param value Whether a budget uses the amortized rate. Defaults to `false`
     */
    @JvmName("ykvsrokvpsjiafrr")
    public suspend fun useAmortized(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useAmortized = mapped
    }

    /**
     * @param value A boolean value whether to use blended costs in the cost budget. Defaults to `false`
     */
    @JvmName("jyecbtiearhxkbau")
    public suspend fun useBlended(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useBlended = mapped
    }

    internal fun build(): BudgetCostTypesArgs = BudgetCostTypesArgs(
        includeCredit = includeCredit,
        includeDiscount = includeDiscount,
        includeOtherSubscription = includeOtherSubscription,
        includeRecurring = includeRecurring,
        includeRefund = includeRefund,
        includeSubscription = includeSubscription,
        includeSupport = includeSupport,
        includeTax = includeTax,
        includeUpfront = includeUpfront,
        useAmortized = useAmortized,
        useBlended = useBlended,
    )
}
