@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin.inputs

import com.pulumi.aws.budgets.inputs.BudgetNotificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property comparisonOperator (Required) Comparison operator to use to evaluate the condition. Can be `LESS_THAN`, `EQUAL_TO` or `GREATER_THAN`.
 * @property notificationType (Required) What kind of budget value to notify on. Can be `ACTUAL` or `FORECASTED`
 * @property subscriberEmailAddresses (Optional) E-Mail addresses to notify. Either this or `subscriber_sns_topic_arns` is required.
 * @property subscriberSnsTopicArns (Optional) SNS topics to notify. Either this or `subscriber_email_addresses` is required.
 * @property threshold (Required) Threshold when the notification should be sent.
 * @property thresholdType (Required) What kind of threshold is defined. Can be `PERCENTAGE` OR `ABSOLUTE_VALUE`.
 */
public data class BudgetNotificationArgs(
    public val comparisonOperator: Output<String>,
    public val notificationType: Output<String>,
    public val subscriberEmailAddresses: Output<List<String>>? = null,
    public val subscriberSnsTopicArns: Output<List<String>>? = null,
    public val threshold: Output<Double>,
    public val thresholdType: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.budgets.inputs.BudgetNotificationArgs> {
    override fun toJava(): com.pulumi.aws.budgets.inputs.BudgetNotificationArgs =
        com.pulumi.aws.budgets.inputs.BudgetNotificationArgs.builder()
            .comparisonOperator(comparisonOperator.applyValue({ args0 -> args0 }))
            .notificationType(notificationType.applyValue({ args0 -> args0 }))
            .subscriberEmailAddresses(
                subscriberEmailAddresses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .subscriberSnsTopicArns(
                subscriberSnsTopicArns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .threshold(threshold.applyValue({ args0 -> args0 }))
            .thresholdType(thresholdType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BudgetNotificationArgs].
 */
@PulumiTagMarker
public class BudgetNotificationArgsBuilder internal constructor() {
    private var comparisonOperator: Output<String>? = null

    private var notificationType: Output<String>? = null

    private var subscriberEmailAddresses: Output<List<String>>? = null

    private var subscriberSnsTopicArns: Output<List<String>>? = null

    private var threshold: Output<Double>? = null

    private var thresholdType: Output<String>? = null

    /**
     * @param value (Required) Comparison operator to use to evaluate the condition. Can be `LESS_THAN`, `EQUAL_TO` or `GREATER_THAN`.
     */
    @JvmName("brecnjrrqhimgncn")
    public suspend fun comparisonOperator(`value`: Output<String>) {
        this.comparisonOperator = value
    }

    /**
     * @param value (Required) What kind of budget value to notify on. Can be `ACTUAL` or `FORECASTED`
     */
    @JvmName("aqtarmlwfbbbopun")
    public suspend fun notificationType(`value`: Output<String>) {
        this.notificationType = value
    }

    /**
     * @param value (Optional) E-Mail addresses to notify. Either this or `subscriber_sns_topic_arns` is required.
     */
    @JvmName("xhtsaelrsiwvwffa")
    public suspend fun subscriberEmailAddresses(`value`: Output<List<String>>) {
        this.subscriberEmailAddresses = value
    }

    @JvmName("ataxdrnpsjkrqbyd")
    public suspend fun subscriberEmailAddresses(vararg values: Output<String>) {
        this.subscriberEmailAddresses = Output.all(values.asList())
    }

    /**
     * @param values (Optional) E-Mail addresses to notify. Either this or `subscriber_sns_topic_arns` is required.
     */
    @JvmName("ooytmypujqpeqdjl")
    public suspend fun subscriberEmailAddresses(values: List<Output<String>>) {
        this.subscriberEmailAddresses = Output.all(values)
    }

    /**
     * @param value (Optional) SNS topics to notify. Either this or `subscriber_email_addresses` is required.
     */
    @JvmName("kghwdftfnivybxhk")
    public suspend fun subscriberSnsTopicArns(`value`: Output<List<String>>) {
        this.subscriberSnsTopicArns = value
    }

    @JvmName("mwufudtadbbkxbxh")
    public suspend fun subscriberSnsTopicArns(vararg values: Output<String>) {
        this.subscriberSnsTopicArns = Output.all(values.asList())
    }

    /**
     * @param values (Optional) SNS topics to notify. Either this or `subscriber_email_addresses` is required.
     */
    @JvmName("cwqxvrhagxiqytst")
    public suspend fun subscriberSnsTopicArns(values: List<Output<String>>) {
        this.subscriberSnsTopicArns = Output.all(values)
    }

    /**
     * @param value (Required) Threshold when the notification should be sent.
     */
    @JvmName("kctehmyulpmppily")
    public suspend fun threshold(`value`: Output<Double>) {
        this.threshold = value
    }

    /**
     * @param value (Required) What kind of threshold is defined. Can be `PERCENTAGE` OR `ABSOLUTE_VALUE`.
     */
    @JvmName("bnlruqhpwtqrsuwj")
    public suspend fun thresholdType(`value`: Output<String>) {
        this.thresholdType = value
    }

    /**
     * @param value (Required) Comparison operator to use to evaluate the condition. Can be `LESS_THAN`, `EQUAL_TO` or `GREATER_THAN`.
     */
    @JvmName("irrqsasyfymewmgy")
    public suspend fun comparisonOperator(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.comparisonOperator = mapped
    }

    /**
     * @param value (Required) What kind of budget value to notify on. Can be `ACTUAL` or `FORECASTED`
     */
    @JvmName("svdhlijppcendrwr")
    public suspend fun notificationType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notificationType = mapped
    }

    /**
     * @param value (Optional) E-Mail addresses to notify. Either this or `subscriber_sns_topic_arns` is required.
     */
    @JvmName("aoohefhomqrgiqvd")
    public suspend fun subscriberEmailAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriberEmailAddresses = mapped
    }

    /**
     * @param values (Optional) E-Mail addresses to notify. Either this or `subscriber_sns_topic_arns` is required.
     */
    @JvmName("xuirkyewoxwwcnkq")
    public suspend fun subscriberEmailAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subscriberEmailAddresses = mapped
    }

    /**
     * @param value (Optional) SNS topics to notify. Either this or `subscriber_email_addresses` is required.
     */
    @JvmName("kmvicjhgkexcffue")
    public suspend fun subscriberSnsTopicArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriberSnsTopicArns = mapped
    }

    /**
     * @param values (Optional) SNS topics to notify. Either this or `subscriber_email_addresses` is required.
     */
    @JvmName("yhkipseylndcikcf")
    public suspend fun subscriberSnsTopicArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subscriberSnsTopicArns = mapped
    }

    /**
     * @param value (Required) Threshold when the notification should be sent.
     */
    @JvmName("unoydegorfbeerwb")
    public suspend fun threshold(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.threshold = mapped
    }

    /**
     * @param value (Required) What kind of threshold is defined. Can be `PERCENTAGE` OR `ABSOLUTE_VALUE`.
     */
    @JvmName("hhvctevejvcbmlkj")
    public suspend fun thresholdType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.thresholdType = mapped
    }

    internal fun build(): BudgetNotificationArgs = BudgetNotificationArgs(
        comparisonOperator = comparisonOperator ?: throw PulumiNullFieldException("comparisonOperator"),
        notificationType = notificationType ?: throw PulumiNullFieldException("notificationType"),
        subscriberEmailAddresses = subscriberEmailAddresses,
        subscriberSnsTopicArns = subscriberSnsTopicArns,
        threshold = threshold ?: throw PulumiNullFieldException("threshold"),
        thresholdType = thresholdType ?: throw PulumiNullFieldException("thresholdType"),
    )
}
