@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin.inputs

import com.pulumi.aws.budgets.inputs.GetBudgetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getBudget.
 * @property accountId The ID of the target account for budget. Will use current user's account_id by default if omitted.
 * @property name The name of a budget. Unique within accounts.
 * The following arguments are optional:
 * @property namePrefix The prefix of the name of a budget. Unique within accounts.
 */
public data class GetBudgetPlainArgs(
    public val accountId: String? = null,
    public val name: String,
    public val namePrefix: String? = null,
) : ConvertibleToJava<com.pulumi.aws.budgets.inputs.GetBudgetPlainArgs> {
    override fun toJava(): com.pulumi.aws.budgets.inputs.GetBudgetPlainArgs =
        com.pulumi.aws.budgets.inputs.GetBudgetPlainArgs.builder()
            .accountId(accountId?.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .namePrefix(namePrefix?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBudgetPlainArgs].
 */
@PulumiTagMarker
public class GetBudgetPlainArgsBuilder internal constructor() {
    private var accountId: String? = null

    private var name: String? = null

    private var namePrefix: String? = null

    /**
     * @param value The ID of the target account for budget. Will use current user's account_id by default if omitted.
     */
    @JvmName("wnnwmuqmgoagndop")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.accountId = mapped
    }

    /**
     * @param value The name of a budget. Unique within accounts.
     * The following arguments are optional:
     */
    @JvmName("nmakkpneypcnnkxr")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The prefix of the name of a budget. Unique within accounts.
     */
    @JvmName("coexyhffnpvoqgmf")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.namePrefix = mapped
    }

    internal fun build(): GetBudgetPlainArgs = GetBudgetPlainArgs(
        accountId = accountId,
        name = name ?: throw PulumiNullFieldException("name"),
        namePrefix = namePrefix,
    )
}
