@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property groups A list of groups to be attached. There must be at least one group.
 * @property policyArn The Amazon Resource Name (ARN) of the policy to be attached.
 * @property roles A list of roles to be attached. There must be at least one role.
 * @property users A list of users to be attached. There must be at least one user.
 */
public data class BudgetActionDefinitionIamActionDefinition(
    public val groups: List<String>? = null,
    public val policyArn: String,
    public val roles: List<String>? = null,
    public val users: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.budgets.outputs.BudgetActionDefinitionIamActionDefinition):
            BudgetActionDefinitionIamActionDefinition = BudgetActionDefinitionIamActionDefinition(
            groups = javaType.groups().map({ args0 -> args0 }),
            policyArn = javaType.policyArn(),
            roles = javaType.roles().map({ args0 -> args0 }),
            users = javaType.users().map({ args0 -> args0 }),
        )
    }
}
