@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property policyId The policy ID attached.
 * @property targetIds A list of target IDs.
 */
public data class BudgetActionDefinitionScpActionDefinition(
    public val policyId: String,
    public val targetIds: List<String>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.budgets.outputs.BudgetActionDefinitionScpActionDefinition):
            BudgetActionDefinitionScpActionDefinition = BudgetActionDefinitionScpActionDefinition(
            policyId = javaType.policyId(),
            targetIds = javaType.targetIds().map({ args0 -> args0 }),
        )
    }
}
