@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property actionSubType The action subType. Valid values are `STOP_EC2_INSTANCES` or `STOP_RDS_INSTANCES`.
 * @property instanceIds The EC2 and RDS instance IDs.
 * @property region The Region to run the SSM document.
 */
public data class BudgetActionDefinitionSsmActionDefinition(
    public val actionSubType: String,
    public val instanceIds: List<String>,
    public val region: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.budgets.outputs.BudgetActionDefinitionSsmActionDefinition):
            BudgetActionDefinitionSsmActionDefinition = BudgetActionDefinitionSsmActionDefinition(
            actionSubType = javaType.actionSubType(),
            instanceIds = javaType.instanceIds().map({ args0 -> args0 }),
            region = javaType.region(),
        )
    }
}
