@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property address The address that AWS sends budget notifications to, either an SNS topic or an email.
 * @property subscriptionType The type of notification that AWS sends to a subscriber. Valid values are `SNS` or `EMAIL`.
 */
public data class BudgetActionSubscriber(
    public val address: String,
    public val subscriptionType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.budgets.outputs.BudgetActionSubscriber):
            BudgetActionSubscriber = BudgetActionSubscriber(
            address = javaType.address(),
            subscriptionType = javaType.subscriptionType(),
        )
    }
}
