@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property autoAdjustType
 * @property historicalOptions
 * @property lastAutoAdjustTime
 */
public data class BudgetAutoAdjustData(
    public val autoAdjustType: String,
    public val historicalOptions: BudgetAutoAdjustDataHistoricalOptions? = null,
    public val lastAutoAdjustTime: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.budgets.outputs.BudgetAutoAdjustData):
            BudgetAutoAdjustData = BudgetAutoAdjustData(
            autoAdjustType = javaType.autoAdjustType(),
            historicalOptions = javaType.historicalOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.budgets.kotlin.outputs.BudgetAutoAdjustDataHistoricalOptions.Companion.toKotlin(args0)
                })
            }).orElse(null),
            lastAutoAdjustTime = javaType.lastAutoAdjustTime().map({ args0 -> args0 }).orElse(null),
        )
    }
}
