@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property budgetAdjustmentPeriod
 * @property lookbackAvailablePeriods
 */
public data class BudgetAutoAdjustDataHistoricalOptions(
    public val budgetAdjustmentPeriod: Int,
    public val lookbackAvailablePeriods: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.budgets.outputs.BudgetAutoAdjustDataHistoricalOptions):
            BudgetAutoAdjustDataHistoricalOptions = BudgetAutoAdjustDataHistoricalOptions(
            budgetAdjustmentPeriod = javaType.budgetAdjustmentPeriod(),
            lookbackAvailablePeriods = javaType.lookbackAvailablePeriods().map({ args0 -> args0 }).orElse(null),
        )
    }
}
