@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property includeCredit A boolean value whether to include credits in the cost budget. Defaults to `true`
 * @property includeDiscount Whether a budget includes discounts. Defaults to `true`
 * @property includeOtherSubscription A boolean value whether to include other subscription costs in the cost budget. Defaults to `true`
 * @property includeRecurring A boolean value whether to include recurring costs in the cost budget. Defaults to `true`
 * @property includeRefund A boolean value whether to include refunds in the cost budget. Defaults to `true`
 * @property includeSubscription A boolean value whether to include subscriptions in the cost budget. Defaults to `true`
 * @property includeSupport A boolean value whether to include support costs in the cost budget. Defaults to `true`
 * @property includeTax A boolean value whether to include tax in the cost budget. Defaults to `true`
 * @property includeUpfront A boolean value whether to include upfront costs in the cost budget. Defaults to `true`
 * @property useAmortized Whether a budget uses the amortized rate. Defaults to `false`
 * @property useBlended A boolean value whether to use blended costs in the cost budget. Defaults to `false`
 */
public data class BudgetCostTypes(
    public val includeCredit: Boolean? = null,
    public val includeDiscount: Boolean? = null,
    public val includeOtherSubscription: Boolean? = null,
    public val includeRecurring: Boolean? = null,
    public val includeRefund: Boolean? = null,
    public val includeSubscription: Boolean? = null,
    public val includeSupport: Boolean? = null,
    public val includeTax: Boolean? = null,
    public val includeUpfront: Boolean? = null,
    public val useAmortized: Boolean? = null,
    public val useBlended: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.budgets.outputs.BudgetCostTypes): BudgetCostTypes =
            BudgetCostTypes(
                includeCredit = javaType.includeCredit().map({ args0 -> args0 }).orElse(null),
                includeDiscount = javaType.includeDiscount().map({ args0 -> args0 }).orElse(null),
                includeOtherSubscription = javaType.includeOtherSubscription().map({ args0 -> args0 }).orElse(null),
                includeRecurring = javaType.includeRecurring().map({ args0 -> args0 }).orElse(null),
                includeRefund = javaType.includeRefund().map({ args0 -> args0 }).orElse(null),
                includeSubscription = javaType.includeSubscription().map({ args0 -> args0 }).orElse(null),
                includeSupport = javaType.includeSupport().map({ args0 -> args0 }).orElse(null),
                includeTax = javaType.includeTax().map({ args0 -> args0 }).orElse(null),
                includeUpfront = javaType.includeUpfront().map({ args0 -> args0 }).orElse(null),
                useAmortized = javaType.useAmortized().map({ args0 -> args0 }).orElse(null),
                useBlended = javaType.useBlended().map({ args0 -> args0 }).orElse(null),
            )
    }
}
