@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property comparisonOperator (Required) Comparison operator to use to evaluate the condition. Can be `LESS_THAN`, `EQUAL_TO` or `GREATER_THAN`.
 * @property notificationType (Required) What kind of budget value to notify on. Can be `ACTUAL` or `FORECASTED`
 * @property subscriberEmailAddresses (Optional) E-Mail addresses to notify. Either this or `subscriber_sns_topic_arns` is required.
 * @property subscriberSnsTopicArns (Optional) SNS topics to notify. Either this or `subscriber_email_addresses` is required.
 * @property threshold (Required) Threshold when the notification should be sent.
 * @property thresholdType (Required) What kind of threshold is defined. Can be `PERCENTAGE` OR `ABSOLUTE_VALUE`.
 */
public data class BudgetNotification(
    public val comparisonOperator: String,
    public val notificationType: String,
    public val subscriberEmailAddresses: List<String>? = null,
    public val subscriberSnsTopicArns: List<String>? = null,
    public val threshold: Double,
    public val thresholdType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.budgets.outputs.BudgetNotification):
            BudgetNotification = BudgetNotification(
            comparisonOperator = javaType.comparisonOperator(),
            notificationType = javaType.notificationType(),
            subscriberEmailAddresses = javaType.subscriberEmailAddresses().map({ args0 -> args0 }),
            subscriberSnsTopicArns = javaType.subscriberSnsTopicArns().map({ args0 -> args0 }),
            threshold = javaType.threshold(),
            thresholdType = javaType.thresholdType(),
        )
    }
}
