@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property autoAdjustType (Required) - The string that defines whether your budget auto-adjusts based on historical or forecasted data. Valid values: `FORECAST`,`HISTORICAL`.
 * @property historicalOptions (Optional) - Configuration block of Historical Options. Required for `auto_adjust_type` of `HISTORICAL` Configuration block that defines the historical data that your auto-adjusting budget is based on.
 * @property lastAutoAdjustTime (Optional) - The last time that your budget was auto-adjusted.
 */
public data class GetBudgetAutoAdjustData(
    public val autoAdjustType: String,
    public val historicalOptions: List<GetBudgetAutoAdjustDataHistoricalOption>,
    public val lastAutoAdjustTime: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.budgets.outputs.GetBudgetAutoAdjustData):
            GetBudgetAutoAdjustData = GetBudgetAutoAdjustData(
            autoAdjustType = javaType.autoAdjustType(),
            historicalOptions = javaType.historicalOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.budgets.kotlin.outputs.GetBudgetAutoAdjustDataHistoricalOption.Companion.toKotlin(args0)
                })
            }),
            lastAutoAdjustTime = javaType.lastAutoAdjustTime(),
        )
    }
}
