@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property amount The cost or usage amount that's associated with a budget forecast, actual spend, or budget threshold. Length Constraints: Minimum length of `1`. Maximum length of `2147483647`.
 * @property unit The unit of measurement that's used for the budget forecast, actual spend, or budget threshold, such as USD or GBP. Length Constraints: Minimum length of `1`. Maximum length of `2147483647`.
 */
public data class GetBudgetCalculatedSpendActualSpend(
    public val amount: String,
    public val unit: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.budgets.outputs.GetBudgetCalculatedSpendActualSpend):
            GetBudgetCalculatedSpendActualSpend = GetBudgetCalculatedSpendActualSpend(
            amount = javaType.amount(),
            unit = javaType.unit(),
        )
    }
}
