@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property includeCredit A boolean value whether to include credits in the cost budget. Defaults to `true`.
 * @property includeDiscount Whether a budget includes discounts. Defaults to `true`.
 * @property includeOtherSubscription A boolean value whether to include other subscription costs in the cost budget. Defaults to `true`.
 * @property includeRecurring A boolean value whether to include recurring costs in the cost budget. Defaults to `true`.
 * @property includeRefund A boolean value whether to include refunds in the cost budget. Defaults to `true`.
 * @property includeSubscription A boolean value whether to include subscriptions in the cost budget. Defaults to `true`.
 * @property includeSupport A boolean value whether to include support costs in the cost budget. Defaults to `true`.
 * @property includeTax A boolean value whether to include tax in the cost budget. Defaults to `true`.
 * @property includeUpfront A boolean value whether to include upfront costs in the cost budget. Defaults to `true`.
 * @property useAmortized Whether a budget uses the amortized rate. Defaults to `false`.
 * @property useBlended A boolean value whether to use blended costs in the cost budget. Defaults to `false`.
 */
public data class GetBudgetCostType(
    public val includeCredit: Boolean,
    public val includeDiscount: Boolean,
    public val includeOtherSubscription: Boolean,
    public val includeRecurring: Boolean,
    public val includeRefund: Boolean,
    public val includeSubscription: Boolean,
    public val includeSupport: Boolean,
    public val includeTax: Boolean,
    public val includeUpfront: Boolean,
    public val useAmortized: Boolean,
    public val useBlended: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.budgets.outputs.GetBudgetCostType):
            GetBudgetCostType = GetBudgetCostType(
            includeCredit = javaType.includeCredit(),
            includeDiscount = javaType.includeDiscount(),
            includeOtherSubscription = javaType.includeOtherSubscription(),
            includeRecurring = javaType.includeRecurring(),
            includeRefund = javaType.includeRefund(),
            includeSubscription = javaType.includeSubscription(),
            includeSupport = javaType.includeSupport(),
            includeTax = javaType.includeTax(),
            includeUpfront = javaType.includeUpfront(),
            useAmortized = javaType.useAmortized(),
            useBlended = javaType.useBlended(),
        )
    }
}
