@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [AggregateAuthorization].
 */
@PulumiTagMarker
public class AggregateAuthorizationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AggregateAuthorizationArgs = AggregateAuthorizationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AggregateAuthorizationArgsBuilder.() -> Unit) {
        val builder = AggregateAuthorizationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AggregateAuthorization {
        val builtJavaResource = com.pulumi.aws.cfg.AggregateAuthorization(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AggregateAuthorization(builtJavaResource)
    }
}

/**
 * Manages an AWS Config Aggregate Authorization
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cfg.AggregateAuthorization;
 * import com.pulumi.aws.cfg.AggregateAuthorizationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AggregateAuthorization("example", AggregateAuthorizationArgs.builder()
 *             .accountId("123456789012")
 *             .region("eu-west-2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Config aggregate authorizations using `account_id:region`. For example:
 * ```sh
 *  $ pulumi import aws:cfg/aggregateAuthorization:AggregateAuthorization example 123456789012:us-east-1
 * ```
 *
 */
public class AggregateAuthorization internal constructor(
    override val javaResource: com.pulumi.aws.cfg.AggregateAuthorization,
) : KotlinCustomResource(javaResource, AggregateAuthorizationMapper) {
    /**
     * Account ID
     */
    public val accountId: Output<String>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })

    /**
     * The ARN of the authorization
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Region
     */
    public val region: Output<String>
        get() = javaResource.region().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object AggregateAuthorizationMapper : ResourceMapper<AggregateAuthorization> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cfg.AggregateAuthorization::class == javaResource::class

    override fun map(javaResource: Resource): AggregateAuthorization =
        AggregateAuthorization(javaResource as com.pulumi.aws.cfg.AggregateAuthorization)
}

/**
 * @see [AggregateAuthorization].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AggregateAuthorization].
 */
public suspend fun aggregateAuthorization(
    name: String,
    block: suspend AggregateAuthorizationResourceBuilder.() -> Unit,
): AggregateAuthorization {
    val builder = AggregateAuthorizationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AggregateAuthorization].
 * @param name The _unique_ name of the resulting resource.
 */
public fun aggregateAuthorization(name: String): AggregateAuthorization {
    val builder = AggregateAuthorizationResourceBuilder()
    builder.name(name)
    return builder.build()
}
