@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin

import com.pulumi.aws.cfg.AggregateAuthorizationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an AWS Config Aggregate Authorization
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cfg.AggregateAuthorization;
 * import com.pulumi.aws.cfg.AggregateAuthorizationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AggregateAuthorization("example", AggregateAuthorizationArgs.builder()
 *             .accountId("123456789012")
 *             .region("eu-west-2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Config aggregate authorizations using `account_id:region`. For example:
 * ```sh
 *  $ pulumi import aws:cfg/aggregateAuthorization:AggregateAuthorization example 123456789012:us-east-1
 * ```
 * @property accountId Account ID
 * @property region Region
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class AggregateAuthorizationArgs(
    public val accountId: Output<String>? = null,
    public val region: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.cfg.AggregateAuthorizationArgs> {
    override fun toJava(): com.pulumi.aws.cfg.AggregateAuthorizationArgs =
        com.pulumi.aws.cfg.AggregateAuthorizationArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .region(region?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AggregateAuthorizationArgs].
 */
@PulumiTagMarker
public class AggregateAuthorizationArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var region: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Account ID
     */
    @JvmName("wfqowkodbjugofuf")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value Region
     */
    @JvmName("jydlmujxhkabyspi")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jarcrnkyqgpmwmso")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Account ID
     */
    @JvmName("idrulnyinatswvko")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value Region
     */
    @JvmName("supllixjdqhlqsci")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.region = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fwlmuktxaqcrsdql")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xxmgrkpvdxfykrbg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AggregateAuthorizationArgs = AggregateAuthorizationArgs(
        accountId = accountId,
        region = region,
        tags = tags,
    )
}
