@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin

import com.pulumi.aws.cfg.kotlin.outputs.ConfigurationAggregatorAccountAggregationSource
import com.pulumi.aws.cfg.kotlin.outputs.ConfigurationAggregatorOrganizationAggregationSource
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.cfg.kotlin.outputs.ConfigurationAggregatorAccountAggregationSource.Companion.toKotlin as configurationAggregatorAccountAggregationSourceToKotlin
import com.pulumi.aws.cfg.kotlin.outputs.ConfigurationAggregatorOrganizationAggregationSource.Companion.toKotlin as configurationAggregatorOrganizationAggregationSourceToKotlin

/**
 * Builder for [ConfigurationAggregator].
 */
@PulumiTagMarker
public class ConfigurationAggregatorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConfigurationAggregatorArgs = ConfigurationAggregatorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConfigurationAggregatorArgsBuilder.() -> Unit) {
        val builder = ConfigurationAggregatorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ConfigurationAggregator {
        val builtJavaResource = com.pulumi.aws.cfg.ConfigurationAggregator(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ConfigurationAggregator(builtJavaResource)
    }
}

/**
 * Manages an AWS Config Configuration Aggregator
 * ## Example Usage
 * ### Account Based Aggregation
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cfg.ConfigurationAggregator;
 * import com.pulumi.aws.cfg.ConfigurationAggregatorArgs;
 * import com.pulumi.aws.cfg.inputs.ConfigurationAggregatorAccountAggregationSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var account = new ConfigurationAggregator("account", ConfigurationAggregatorArgs.builder()
 *             .accountAggregationSource(ConfigurationAggregatorAccountAggregationSourceArgs.builder()
 *                 .accountIds("123456789012")
 *                 .regions("us-west-2")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Organization Based Aggregation
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.cfg.ConfigurationAggregator;
 * import com.pulumi.aws.cfg.ConfigurationAggregatorArgs;
 * import com.pulumi.aws.cfg.inputs.ConfigurationAggregatorOrganizationAggregationSourceArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("config.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var organizationRole = new Role("organizationRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var organizationRolePolicyAttachment = new RolePolicyAttachment("organizationRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .role(organizationRole.name())
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AWSConfigRoleForOrganizations")
 *             .build());
 *         var organizationConfigurationAggregator = new ConfigurationAggregator("organizationConfigurationAggregator", ConfigurationAggregatorArgs.builder()
 *             .organizationAggregationSource(ConfigurationAggregatorOrganizationAggregationSourceArgs.builder()
 *                 .allRegions(true)
 *                 .roleArn(organizationRole.arn())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(organizationRolePolicyAttachment)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Configuration Aggregators using the name. For example:
 * ```sh
 *  $ pulumi import aws:cfg/configurationAggregator:ConfigurationAggregator example foo
 * ```
 *
 */
public class ConfigurationAggregator internal constructor(
    override val javaResource: com.pulumi.aws.cfg.ConfigurationAggregator,
) : KotlinCustomResource(javaResource, ConfigurationAggregatorMapper) {
    /**
     * The account(s) to aggregate config data from as documented below.
     */
    public val accountAggregationSource: Output<ConfigurationAggregatorAccountAggregationSource>?
        get() = javaResource.accountAggregationSource().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    configurationAggregatorAccountAggregationSourceToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The ARN of the aggregator
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name of the configuration aggregator.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The organization to aggregate config data from as documented below.
     */
    public val organizationAggregationSource:
        Output<ConfigurationAggregatorOrganizationAggregationSource>?
        get() = javaResource.organizationAggregationSource().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    configurationAggregatorOrganizationAggregationSourceToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * Either `account_aggregation_source` or `organization_aggregation_source` must be specified.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ConfigurationAggregatorMapper : ResourceMapper<ConfigurationAggregator> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cfg.ConfigurationAggregator::class == javaResource::class

    override fun map(javaResource: Resource): ConfigurationAggregator =
        ConfigurationAggregator(javaResource as com.pulumi.aws.cfg.ConfigurationAggregator)
}

/**
 * @see [ConfigurationAggregator].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConfigurationAggregator].
 */
public suspend fun configurationAggregator(
    name: String,
    block: suspend ConfigurationAggregatorResourceBuilder.() -> Unit,
): ConfigurationAggregator {
    val builder = ConfigurationAggregatorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConfigurationAggregator].
 * @param name The _unique_ name of the resulting resource.
 */
public fun configurationAggregator(name: String): ConfigurationAggregator {
    val builder = ConfigurationAggregatorResourceBuilder()
    builder.name(name)
    return builder.build()
}
