@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin

import com.pulumi.aws.cfg.ConfigurationAggregatorArgs.builder
import com.pulumi.aws.cfg.kotlin.inputs.ConfigurationAggregatorAccountAggregationSourceArgs
import com.pulumi.aws.cfg.kotlin.inputs.ConfigurationAggregatorAccountAggregationSourceArgsBuilder
import com.pulumi.aws.cfg.kotlin.inputs.ConfigurationAggregatorOrganizationAggregationSourceArgs
import com.pulumi.aws.cfg.kotlin.inputs.ConfigurationAggregatorOrganizationAggregationSourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an AWS Config Configuration Aggregator
 * ## Example Usage
 * ### Account Based Aggregation
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cfg.ConfigurationAggregator;
 * import com.pulumi.aws.cfg.ConfigurationAggregatorArgs;
 * import com.pulumi.aws.cfg.inputs.ConfigurationAggregatorAccountAggregationSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var account = new ConfigurationAggregator("account", ConfigurationAggregatorArgs.builder()
 *             .accountAggregationSource(ConfigurationAggregatorAccountAggregationSourceArgs.builder()
 *                 .accountIds("123456789012")
 *                 .regions("us-west-2")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Organization Based Aggregation
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.cfg.ConfigurationAggregator;
 * import com.pulumi.aws.cfg.ConfigurationAggregatorArgs;
 * import com.pulumi.aws.cfg.inputs.ConfigurationAggregatorOrganizationAggregationSourceArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("config.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var organizationRole = new Role("organizationRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var organizationRolePolicyAttachment = new RolePolicyAttachment("organizationRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .role(organizationRole.name())
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AWSConfigRoleForOrganizations")
 *             .build());
 *         var organizationConfigurationAggregator = new ConfigurationAggregator("organizationConfigurationAggregator", ConfigurationAggregatorArgs.builder()
 *             .organizationAggregationSource(ConfigurationAggregatorOrganizationAggregationSourceArgs.builder()
 *                 .allRegions(true)
 *                 .roleArn(organizationRole.arn())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(organizationRolePolicyAttachment)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Configuration Aggregators using the name. For example:
 * ```sh
 *  $ pulumi import aws:cfg/configurationAggregator:ConfigurationAggregator example foo
 * ```
 * @property accountAggregationSource The account(s) to aggregate config data from as documented below.
 * @property name The name of the configuration aggregator.
 * @property organizationAggregationSource The organization to aggregate config data from as documented below.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * Either `account_aggregation_source` or `organization_aggregation_source` must be specified.
 */
public data class ConfigurationAggregatorArgs(
    public val accountAggregationSource: Output<ConfigurationAggregatorAccountAggregationSourceArgs>? =
        null,
    public val name: Output<String>? = null,
    public val organizationAggregationSource:
    Output<ConfigurationAggregatorOrganizationAggregationSourceArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.cfg.ConfigurationAggregatorArgs> {
    override fun toJava(): com.pulumi.aws.cfg.ConfigurationAggregatorArgs =
        com.pulumi.aws.cfg.ConfigurationAggregatorArgs.builder()
            .accountAggregationSource(
                accountAggregationSource?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .organizationAggregationSource(
                organizationAggregationSource?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ConfigurationAggregatorArgs].
 */
@PulumiTagMarker
public class ConfigurationAggregatorArgsBuilder internal constructor() {
    private var accountAggregationSource: Output<ConfigurationAggregatorAccountAggregationSourceArgs>? =
        null

    private var name: Output<String>? = null

    private var organizationAggregationSource:
        Output<ConfigurationAggregatorOrganizationAggregationSourceArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The account(s) to aggregate config data from as documented below.
     */
    @JvmName("xelyhkbgipbxjgnj")
    public suspend
    fun accountAggregationSource(`value`: Output<ConfigurationAggregatorAccountAggregationSourceArgs>) {
        this.accountAggregationSource = value
    }

    /**
     * @param value The name of the configuration aggregator.
     */
    @JvmName("aybnfenklsbjlwdu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The organization to aggregate config data from as documented below.
     */
    @JvmName("ditppbilslfruwhi")
    public suspend
    fun organizationAggregationSource(`value`: Output<ConfigurationAggregatorOrganizationAggregationSourceArgs>) {
        this.organizationAggregationSource = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * Either `account_aggregation_source` or `organization_aggregation_source` must be specified.
     */
    @JvmName("xnqenyepowctoqjm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The account(s) to aggregate config data from as documented below.
     */
    @JvmName("etymkphoieiqhnyk")
    public suspend
    fun accountAggregationSource(`value`: ConfigurationAggregatorAccountAggregationSourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountAggregationSource = mapped
    }

    /**
     * @param argument The account(s) to aggregate config data from as documented below.
     */
    @JvmName("ffdunaplxsnhpihx")
    public suspend
    fun accountAggregationSource(argument: suspend ConfigurationAggregatorAccountAggregationSourceArgsBuilder.() -> Unit) {
        val toBeMapped = ConfigurationAggregatorAccountAggregationSourceArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.accountAggregationSource = mapped
    }

    /**
     * @param value The name of the configuration aggregator.
     */
    @JvmName("tvjdivkofeukufji")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The organization to aggregate config data from as documented below.
     */
    @JvmName("hrxdmgjwpidfgacr")
    public suspend
    fun organizationAggregationSource(`value`: ConfigurationAggregatorOrganizationAggregationSourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.organizationAggregationSource = mapped
    }

    /**
     * @param argument The organization to aggregate config data from as documented below.
     */
    @JvmName("jahdthegehlyyrtg")
    public suspend
    fun organizationAggregationSource(argument: suspend ConfigurationAggregatorOrganizationAggregationSourceArgsBuilder.() -> Unit) {
        val toBeMapped = ConfigurationAggregatorOrganizationAggregationSourceArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.organizationAggregationSource = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * Either `account_aggregation_source` or `organization_aggregation_source` must be specified.
     */
    @JvmName("bjctpqqtobvsahbj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * Either `account_aggregation_source` or `organization_aggregation_source` must be specified.
     */
    @JvmName("vflmvdclctrpbsbx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ConfigurationAggregatorArgs = ConfigurationAggregatorArgs(
        accountAggregationSource = accountAggregationSource,
        name = name,
        organizationAggregationSource = organizationAggregationSource,
        tags = tags,
    )
}
