@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin

import com.pulumi.aws.cfg.kotlin.outputs.ConformancePackInputParameter
import com.pulumi.aws.cfg.kotlin.outputs.ConformancePackInputParameter.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ConformancePack].
 */
@PulumiTagMarker
public class ConformancePackResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConformancePackArgs = ConformancePackArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConformancePackArgsBuilder.() -> Unit) {
        val builder = ConformancePackArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ConformancePack {
        val builtJavaResource = com.pulumi.aws.cfg.ConformancePack(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ConformancePack(builtJavaResource)
    }
}

/**
 * Manages a Config Conformance Pack. More information about this collection of Config rules and remediation actions can be found in the
 * [Conformance Packs](https://docs.aws.amazon.com/config/latest/developerguide/conformance-packs.html) documentation.
 * Sample Conformance Pack templates may be found in the
 * [AWS Config Rules Repository](https://github.com/awslabs/aws-config-rules/tree/master/aws-config-conformance-packs).
 * > **NOTE:** The account must have a Configuration Recorder with proper IAM permissions before the Conformance Pack will
 * successfully create or update. See also the
 * `aws.cfg.Recorder` resource.
 * ## Example Usage
 * ### Template Body
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cfg.ConformancePack;
 * import com.pulumi.aws.cfg.ConformancePackArgs;
 * import com.pulumi.aws.cfg.inputs.ConformancePackInputParameterArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ConformancePack("example", ConformancePackArgs.builder()
 *             .inputParameters(ConformancePackInputParameterArgs.builder()
 *                 .parameterName("AccessKeysRotatedParameterMaxAccessKeyAge")
 *                 .parameterValue("90")
 *                 .build())
 *             .templateBody("""
 * Parameters:
 *   AccessKeysRotatedParameterMaxAccessKeyAge:
 *     Type: String
 * Resources:
 *   IAMPasswordPolicy:
 *     Properties:
 *       ConfigRuleName: IAMPasswordPolicy
 *       Source:
 *         Owner: AWS
 *         SourceIdentifier: IAM_PASSWORD_POLICY
 *     Type: AWS::Config::ConfigRule
 *             """)
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_config_configuration_recorder.example())
 *                 .build());
 *     }
 * }
 * ```
 * ### Template S3 URI
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketObjectv2;
 * import com.pulumi.aws.s3.BucketObjectv2Args;
 * import com.pulumi.aws.cfg.ConformancePack;
 * import com.pulumi.aws.cfg.ConformancePackArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleBucketObjectv2 = new BucketObjectv2("exampleBucketObjectv2", BucketObjectv2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .key("example-key")
 *             .content("""
 * Resources:
 *   IAMPasswordPolicy:
 *     Properties:
 *       ConfigRuleName: IAMPasswordPolicy
 *       Source:
 *         Owner: AWS
 *         SourceIdentifier: IAM_PASSWORD_POLICY
 *     Type: AWS::Config::ConfigRule
 *             """)
 *             .build());
 *         var exampleConformancePack = new ConformancePack("exampleConformancePack", ConformancePackArgs.builder()
 *             .templateS3Uri(Output.tuple(exampleBucketV2.bucket(), exampleBucketObjectv2.key()).applyValue(values -> {
 *                 var bucket = values.t1;
 *                 var key = values.t2;
 *                 return String.format("s3://%s/%s", bucket,key);
 *             }))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_config_configuration_recorder.example())
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Config Conformance Packs using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:cfg/conformancePack:ConformancePack example example
 * ```
 *
 */
public class ConformancePack internal constructor(
    override val javaResource: com.pulumi.aws.cfg.ConformancePack,
) : KotlinCustomResource(javaResource, ConformancePackMapper) {
    /**
     * Amazon Resource Name (ARN) of the conformance pack.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Amazon S3 bucket where AWS Config stores conformance pack templates. Maximum length of 63.
     */
    public val deliveryS3Bucket: Output<String>?
        get() = javaResource.deliveryS3Bucket().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The prefix for the Amazon S3 bucket. Maximum length of 1024.
     */
    public val deliveryS3KeyPrefix: Output<String>?
        get() = javaResource.deliveryS3KeyPrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Set of configuration blocks describing input parameters passed to the conformance pack template. Documented below. When configured, the parameters must also be included in the `template_body` or in the template stored in Amazon S3 if using `template_s3_uri`.
     */
    public val inputParameters: Output<List<ConformancePackInputParameter>>?
        get() = javaResource.inputParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * The name of the conformance pack. Must begin with a letter and contain from 1 to 256 alphanumeric characters and hyphens.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A string containing full conformance pack template body. Maximum length of 51200. Drift detection is not possible with this argument.
     */
    public val templateBody: Output<String>?
        get() = javaResource.templateBody().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Location of file, e.g., `s3://bucketname/prefix`, containing the template body. The uri must point to the conformance pack template that is located in an Amazon S3 bucket in the same region as the conformance pack. Maximum length of 1024. Drift detection is not possible with this argument.
     */
    public val templateS3Uri: Output<String>?
        get() = javaResource.templateS3Uri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object ConformancePackMapper : ResourceMapper<ConformancePack> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cfg.ConformancePack::class == javaResource::class

    override fun map(javaResource: Resource): ConformancePack = ConformancePack(
        javaResource as
            com.pulumi.aws.cfg.ConformancePack,
    )
}

/**
 * @see [ConformancePack].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConformancePack].
 */
public suspend fun conformancePack(
    name: String,
    block: suspend ConformancePackResourceBuilder.() -> Unit,
): ConformancePack {
    val builder = ConformancePackResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConformancePack].
 * @param name The _unique_ name of the resulting resource.
 */
public fun conformancePack(name: String): ConformancePack {
    val builder = ConformancePackResourceBuilder()
    builder.name(name)
    return builder.build()
}
