@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin

import com.pulumi.aws.cfg.ConformancePackArgs.builder
import com.pulumi.aws.cfg.kotlin.inputs.ConformancePackInputParameterArgs
import com.pulumi.aws.cfg.kotlin.inputs.ConformancePackInputParameterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Manages a Config Conformance Pack. More information about this collection of Config rules and remediation actions can be found in the
 * [Conformance Packs](https://docs.aws.amazon.com/config/latest/developerguide/conformance-packs.html) documentation.
 * Sample Conformance Pack templates may be found in the
 * [AWS Config Rules Repository](https://github.com/awslabs/aws-config-rules/tree/master/aws-config-conformance-packs).
 * > **NOTE:** The account must have a Configuration Recorder with proper IAM permissions before the Conformance Pack will
 * successfully create or update. See also the
 * `aws.cfg.Recorder` resource.
 * ## Example Usage
 * ### Template Body
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cfg.ConformancePack;
 * import com.pulumi.aws.cfg.ConformancePackArgs;
 * import com.pulumi.aws.cfg.inputs.ConformancePackInputParameterArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ConformancePack("example", ConformancePackArgs.builder()
 *             .inputParameters(ConformancePackInputParameterArgs.builder()
 *                 .parameterName("AccessKeysRotatedParameterMaxAccessKeyAge")
 *                 .parameterValue("90")
 *                 .build())
 *             .templateBody("""
 * Parameters:
 *   AccessKeysRotatedParameterMaxAccessKeyAge:
 *     Type: String
 * Resources:
 *   IAMPasswordPolicy:
 *     Properties:
 *       ConfigRuleName: IAMPasswordPolicy
 *       Source:
 *         Owner: AWS
 *         SourceIdentifier: IAM_PASSWORD_POLICY
 *     Type: AWS::Config::ConfigRule
 *             """)
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_config_configuration_recorder.example())
 *                 .build());
 *     }
 * }
 * ```
 * ### Template S3 URI
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketObjectv2;
 * import com.pulumi.aws.s3.BucketObjectv2Args;
 * import com.pulumi.aws.cfg.ConformancePack;
 * import com.pulumi.aws.cfg.ConformancePackArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleBucketObjectv2 = new BucketObjectv2("exampleBucketObjectv2", BucketObjectv2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .key("example-key")
 *             .content("""
 * Resources:
 *   IAMPasswordPolicy:
 *     Properties:
 *       ConfigRuleName: IAMPasswordPolicy
 *       Source:
 *         Owner: AWS
 *         SourceIdentifier: IAM_PASSWORD_POLICY
 *     Type: AWS::Config::ConfigRule
 *             """)
 *             .build());
 *         var exampleConformancePack = new ConformancePack("exampleConformancePack", ConformancePackArgs.builder()
 *             .templateS3Uri(Output.tuple(exampleBucketV2.bucket(), exampleBucketObjectv2.key()).applyValue(values -> {
 *                 var bucket = values.t1;
 *                 var key = values.t2;
 *                 return String.format("s3://%s/%s", bucket,key);
 *             }))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_config_configuration_recorder.example())
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Config Conformance Packs using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:cfg/conformancePack:ConformancePack example example
 * ```
 * @property deliveryS3Bucket Amazon S3 bucket where AWS Config stores conformance pack templates. Maximum length of 63.
 * @property deliveryS3KeyPrefix The prefix for the Amazon S3 bucket. Maximum length of 1024.
 * @property inputParameters Set of configuration blocks describing input parameters passed to the conformance pack template. Documented below. When configured, the parameters must also be included in the `template_body` or in the template stored in Amazon S3 if using `template_s3_uri`.
 * @property name The name of the conformance pack. Must begin with a letter and contain from 1 to 256 alphanumeric characters and hyphens.
 * @property templateBody A string containing full conformance pack template body. Maximum length of 51200. Drift detection is not possible with this argument.
 * @property templateS3Uri Location of file, e.g., `s3://bucketname/prefix`, containing the template body. The uri must point to the conformance pack template that is located in an Amazon S3 bucket in the same region as the conformance pack. Maximum length of 1024. Drift detection is not possible with this argument.
 */
public data class ConformancePackArgs(
    public val deliveryS3Bucket: Output<String>? = null,
    public val deliveryS3KeyPrefix: Output<String>? = null,
    public val inputParameters: Output<List<ConformancePackInputParameterArgs>>? = null,
    public val name: Output<String>? = null,
    public val templateBody: Output<String>? = null,
    public val templateS3Uri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cfg.ConformancePackArgs> {
    override fun toJava(): com.pulumi.aws.cfg.ConformancePackArgs =
        com.pulumi.aws.cfg.ConformancePackArgs.builder()
            .deliveryS3Bucket(deliveryS3Bucket?.applyValue({ args0 -> args0 }))
            .deliveryS3KeyPrefix(deliveryS3KeyPrefix?.applyValue({ args0 -> args0 }))
            .inputParameters(
                inputParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .templateBody(templateBody?.applyValue({ args0 -> args0 }))
            .templateS3Uri(templateS3Uri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConformancePackArgs].
 */
@PulumiTagMarker
public class ConformancePackArgsBuilder internal constructor() {
    private var deliveryS3Bucket: Output<String>? = null

    private var deliveryS3KeyPrefix: Output<String>? = null

    private var inputParameters: Output<List<ConformancePackInputParameterArgs>>? = null

    private var name: Output<String>? = null

    private var templateBody: Output<String>? = null

    private var templateS3Uri: Output<String>? = null

    /**
     * @param value Amazon S3 bucket where AWS Config stores conformance pack templates. Maximum length of 63.
     */
    @JvmName("lnjycridlubcomtf")
    public suspend fun deliveryS3Bucket(`value`: Output<String>) {
        this.deliveryS3Bucket = value
    }

    /**
     * @param value The prefix for the Amazon S3 bucket. Maximum length of 1024.
     */
    @JvmName("tqddxlbpvenpfrkf")
    public suspend fun deliveryS3KeyPrefix(`value`: Output<String>) {
        this.deliveryS3KeyPrefix = value
    }

    /**
     * @param value Set of configuration blocks describing input parameters passed to the conformance pack template. Documented below. When configured, the parameters must also be included in the `template_body` or in the template stored in Amazon S3 if using `template_s3_uri`.
     */
    @JvmName("efxpyxmtlsgcbpoy")
    public suspend fun inputParameters(`value`: Output<List<ConformancePackInputParameterArgs>>) {
        this.inputParameters = value
    }

    @JvmName("kcbgotbsnufucjpj")
    public suspend fun inputParameters(vararg values: Output<ConformancePackInputParameterArgs>) {
        this.inputParameters = Output.all(values.asList())
    }

    /**
     * @param values Set of configuration blocks describing input parameters passed to the conformance pack template. Documented below. When configured, the parameters must also be included in the `template_body` or in the template stored in Amazon S3 if using `template_s3_uri`.
     */
    @JvmName("gqqpjuaunsqcqvjn")
    public suspend fun inputParameters(values: List<Output<ConformancePackInputParameterArgs>>) {
        this.inputParameters = Output.all(values)
    }

    /**
     * @param value The name of the conformance pack. Must begin with a letter and contain from 1 to 256 alphanumeric characters and hyphens.
     */
    @JvmName("elgamctphuvlrxou")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A string containing full conformance pack template body. Maximum length of 51200. Drift detection is not possible with this argument.
     */
    @JvmName("wvrtejrtwjdphqou")
    public suspend fun templateBody(`value`: Output<String>) {
        this.templateBody = value
    }

    /**
     * @param value Location of file, e.g., `s3://bucketname/prefix`, containing the template body. The uri must point to the conformance pack template that is located in an Amazon S3 bucket in the same region as the conformance pack. Maximum length of 1024. Drift detection is not possible with this argument.
     */
    @JvmName("wyufuquqphqiardn")
    public suspend fun templateS3Uri(`value`: Output<String>) {
        this.templateS3Uri = value
    }

    /**
     * @param value Amazon S3 bucket where AWS Config stores conformance pack templates. Maximum length of 63.
     */
    @JvmName("ukrgjddejcuwjvrf")
    public suspend fun deliveryS3Bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryS3Bucket = mapped
    }

    /**
     * @param value The prefix for the Amazon S3 bucket. Maximum length of 1024.
     */
    @JvmName("dsonmtylxcdtrfgn")
    public suspend fun deliveryS3KeyPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryS3KeyPrefix = mapped
    }

    /**
     * @param value Set of configuration blocks describing input parameters passed to the conformance pack template. Documented below. When configured, the parameters must also be included in the `template_body` or in the template stored in Amazon S3 if using `template_s3_uri`.
     */
    @JvmName("euelaocsxlwhwsuj")
    public suspend fun inputParameters(`value`: List<ConformancePackInputParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputParameters = mapped
    }

    /**
     * @param argument Set of configuration blocks describing input parameters passed to the conformance pack template. Documented below. When configured, the parameters must also be included in the `template_body` or in the template stored in Amazon S3 if using `template_s3_uri`.
     */
    @JvmName("oiyvrudnvyxxnykn")
    public suspend
    fun inputParameters(argument: List<suspend ConformancePackInputParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConformancePackInputParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.inputParameters = mapped
    }

    /**
     * @param argument Set of configuration blocks describing input parameters passed to the conformance pack template. Documented below. When configured, the parameters must also be included in the `template_body` or in the template stored in Amazon S3 if using `template_s3_uri`.
     */
    @JvmName("qepgcbrbspuiudgc")
    public suspend fun inputParameters(
        vararg
        argument: suspend ConformancePackInputParameterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ConformancePackInputParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.inputParameters = mapped
    }

    /**
     * @param argument Set of configuration blocks describing input parameters passed to the conformance pack template. Documented below. When configured, the parameters must also be included in the `template_body` or in the template stored in Amazon S3 if using `template_s3_uri`.
     */
    @JvmName("gcwnwjucvewsppky")
    public suspend
    fun inputParameters(argument: suspend ConformancePackInputParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ConformancePackInputParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.inputParameters = mapped
    }

    /**
     * @param values Set of configuration blocks describing input parameters passed to the conformance pack template. Documented below. When configured, the parameters must also be included in the `template_body` or in the template stored in Amazon S3 if using `template_s3_uri`.
     */
    @JvmName("cgcpaebxiwnbwrgd")
    public suspend fun inputParameters(vararg values: ConformancePackInputParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputParameters = mapped
    }

    /**
     * @param value The name of the conformance pack. Must begin with a letter and contain from 1 to 256 alphanumeric characters and hyphens.
     */
    @JvmName("pdlerydrdgdpcvsw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A string containing full conformance pack template body. Maximum length of 51200. Drift detection is not possible with this argument.
     */
    @JvmName("wdtpvlnpyasprslr")
    public suspend fun templateBody(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateBody = mapped
    }

    /**
     * @param value Location of file, e.g., `s3://bucketname/prefix`, containing the template body. The uri must point to the conformance pack template that is located in an Amazon S3 bucket in the same region as the conformance pack. Maximum length of 1024. Drift detection is not possible with this argument.
     */
    @JvmName("ajiqoepfxkubpxdp")
    public suspend fun templateS3Uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateS3Uri = mapped
    }

    internal fun build(): ConformancePackArgs = ConformancePackArgs(
        deliveryS3Bucket = deliveryS3Bucket,
        deliveryS3KeyPrefix = deliveryS3KeyPrefix,
        inputParameters = inputParameters,
        name = name,
        templateBody = templateBody,
        templateS3Uri = templateS3Uri,
    )
}
