@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin

import com.pulumi.aws.cfg.kotlin.outputs.DeliveryChannelSnapshotDeliveryProperties
import com.pulumi.aws.cfg.kotlin.outputs.DeliveryChannelSnapshotDeliveryProperties.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DeliveryChannel].
 */
@PulumiTagMarker
public class DeliveryChannelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DeliveryChannelArgs = DeliveryChannelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DeliveryChannelArgsBuilder.() -> Unit) {
        val builder = DeliveryChannelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DeliveryChannel {
        val builtJavaResource = com.pulumi.aws.cfg.DeliveryChannel(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DeliveryChannel(builtJavaResource)
    }
}

/**
 * Provides an AWS Config Delivery Channel.
 * > **Note:** Delivery Channel requires a Configuration Recorder to be present. Use of `depends_on` (as shown below) is recommended to avoid race conditions.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.cfg.Recorder;
 * import com.pulumi.aws.cfg.RecorderArgs;
 * import com.pulumi.aws.cfg.DeliveryChannel;
 * import com.pulumi.aws.cfg.DeliveryChannelArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bucketV2 = new BucketV2("bucketV2", BucketV2Args.builder()
 *             .forceDestroy(true)
 *             .build());
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("config.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var role = new Role("role", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var fooRecorder = new Recorder("fooRecorder", RecorderArgs.builder()
 *             .roleArn(role.arn())
 *             .build());
 *         var fooDeliveryChannel = new DeliveryChannel("fooDeliveryChannel", DeliveryChannelArgs.builder()
 *             .s3BucketName(bucketV2.bucket())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(fooRecorder)
 *                 .build());
 *         final var policyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("s3:*")
 *                 .resources(
 *                     bucketV2.arn(),
 *                     bucketV2.arn().applyValue(arn -> String.format("%s/*", arn)))
 *                 .build())
 *             .build());
 *         var rolePolicy = new RolePolicy("rolePolicy", RolePolicyArgs.builder()
 *             .role(role.id())
 *             .policy(policyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(policyDocument -> policyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Delivery Channel using the name. For example:
 * ```sh
 *  $ pulumi import aws:cfg/deliveryChannel:DeliveryChannel foo example
 * ```
 * */
 */
public class DeliveryChannel internal constructor(
    override val javaResource: com.pulumi.aws.cfg.DeliveryChannel,
) : KotlinCustomResource(javaResource, DeliveryChannelMapper) {
    /**
     * The name of the delivery channel. Defaults to `default`. Changing it recreates the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The name of the S3 bucket used to store the configuration history.
     */
    public val s3BucketName: Output<String>
        get() = javaResource.s3BucketName().applyValue({ args0 -> args0 })

    /**
     * The prefix for the specified S3 bucket.
     */
    public val s3KeyPrefix: Output<String>?
        get() = javaResource.s3KeyPrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN of the AWS KMS key used to encrypt objects delivered by AWS Config. Must belong to the same Region as the destination S3 bucket.
     */
    public val s3KmsKeyArn: Output<String>?
        get() = javaResource.s3KmsKeyArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Options for how AWS Config delivers configuration snapshots. See below
     */
    public val snapshotDeliveryProperties: Output<DeliveryChannelSnapshotDeliveryProperties>?
        get() = javaResource.snapshotDeliveryProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The ARN of the SNS topic that AWS Config delivers notifications to.
     */
    public val snsTopicArn: Output<String>?
        get() = javaResource.snsTopicArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object DeliveryChannelMapper : ResourceMapper<DeliveryChannel> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cfg.DeliveryChannel::class == javaResource::class

    override fun map(javaResource: Resource): DeliveryChannel = DeliveryChannel(
        javaResource as
            com.pulumi.aws.cfg.DeliveryChannel,
    )
}

/**
 * @see [DeliveryChannel].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DeliveryChannel].
 */
public suspend fun deliveryChannel(
    name: String,
    block: suspend DeliveryChannelResourceBuilder.() -> Unit,
): DeliveryChannel {
    val builder = DeliveryChannelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DeliveryChannel].
 * @param name The _unique_ name of the resulting resource.
 */
public fun deliveryChannel(name: String): DeliveryChannel {
    val builder = DeliveryChannelResourceBuilder()
    builder.name(name)
    return builder.build()
}
