@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin

import com.pulumi.aws.cfg.DeliveryChannelArgs.builder
import com.pulumi.aws.cfg.kotlin.inputs.DeliveryChannelSnapshotDeliveryPropertiesArgs
import com.pulumi.aws.cfg.kotlin.inputs.DeliveryChannelSnapshotDeliveryPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides an AWS Config Delivery Channel.
 * > **Note:** Delivery Channel requires a Configuration Recorder to be present. Use of `depends_on` (as shown below) is recommended to avoid race conditions.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.cfg.Recorder;
 * import com.pulumi.aws.cfg.RecorderArgs;
 * import com.pulumi.aws.cfg.DeliveryChannel;
 * import com.pulumi.aws.cfg.DeliveryChannelArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bucketV2 = new BucketV2("bucketV2", BucketV2Args.builder()
 *             .forceDestroy(true)
 *             .build());
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("config.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var role = new Role("role", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var fooRecorder = new Recorder("fooRecorder", RecorderArgs.builder()
 *             .roleArn(role.arn())
 *             .build());
 *         var fooDeliveryChannel = new DeliveryChannel("fooDeliveryChannel", DeliveryChannelArgs.builder()
 *             .s3BucketName(bucketV2.bucket())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(fooRecorder)
 *                 .build());
 *         final var policyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("s3:*")
 *                 .resources(
 *                     bucketV2.arn(),
 *                     bucketV2.arn().applyValue(arn -> String.format("%s/*", arn)))
 *                 .build())
 *             .build());
 *         var rolePolicy = new RolePolicy("rolePolicy", RolePolicyArgs.builder()
 *             .role(role.id())
 *             .policy(policyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(policyDocument -> policyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Delivery Channel using the name. For example:
 * ```sh
 *  $ pulumi import aws:cfg/deliveryChannel:DeliveryChannel foo example
 * ```
 * @property name The name of the delivery channel. Defaults to `default`. Changing it recreates the resource.
 * @property s3BucketName The name of the S3 bucket used to store the configuration history.
 * @property s3KeyPrefix The prefix for the specified S3 bucket.
 * @property s3KmsKeyArn The ARN of the AWS KMS key used to encrypt objects delivered by AWS Config. Must belong to the same Region as the destination S3 bucket.
 * @property snapshotDeliveryProperties Options for how AWS Config delivers configuration snapshots. See below
 * @property snsTopicArn The ARN of the SNS topic that AWS Config delivers notifications to.
 * */
 */
public data class DeliveryChannelArgs(
    public val name: Output<String>? = null,
    public val s3BucketName: Output<String>? = null,
    public val s3KeyPrefix: Output<String>? = null,
    public val s3KmsKeyArn: Output<String>? = null,
    public val snapshotDeliveryProperties: Output<DeliveryChannelSnapshotDeliveryPropertiesArgs>? =
        null,
    public val snsTopicArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cfg.DeliveryChannelArgs> {
    override fun toJava(): com.pulumi.aws.cfg.DeliveryChannelArgs =
        com.pulumi.aws.cfg.DeliveryChannelArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .s3BucketName(s3BucketName?.applyValue({ args0 -> args0 }))
            .s3KeyPrefix(s3KeyPrefix?.applyValue({ args0 -> args0 }))
            .s3KmsKeyArn(s3KmsKeyArn?.applyValue({ args0 -> args0 }))
            .snapshotDeliveryProperties(
                snapshotDeliveryProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .snsTopicArn(snsTopicArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeliveryChannelArgs].
 */
@PulumiTagMarker
public class DeliveryChannelArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var s3BucketName: Output<String>? = null

    private var s3KeyPrefix: Output<String>? = null

    private var s3KmsKeyArn: Output<String>? = null

    private var snapshotDeliveryProperties: Output<DeliveryChannelSnapshotDeliveryPropertiesArgs>? =
        null

    private var snsTopicArn: Output<String>? = null

    /**
     * @param value The name of the delivery channel. Defaults to `default`. Changing it recreates the resource.
     */
    @JvmName("gupsnoyqeuxglpkm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the S3 bucket used to store the configuration history.
     */
    @JvmName("jrsyphbtkuqsggeh")
    public suspend fun s3BucketName(`value`: Output<String>) {
        this.s3BucketName = value
    }

    /**
     * @param value The prefix for the specified S3 bucket.
     */
    @JvmName("oeeeqrldvahjrxfd")
    public suspend fun s3KeyPrefix(`value`: Output<String>) {
        this.s3KeyPrefix = value
    }

    /**
     * @param value The ARN of the AWS KMS key used to encrypt objects delivered by AWS Config. Must belong to the same Region as the destination S3 bucket.
     */
    @JvmName("vwbncpjhlruxouyy")
    public suspend fun s3KmsKeyArn(`value`: Output<String>) {
        this.s3KmsKeyArn = value
    }

    /**
     * @param value Options for how AWS Config delivers configuration snapshots. See below
     */
    @JvmName("nbwwcmcsdnvfgpuu")
    public suspend
    fun snapshotDeliveryProperties(`value`: Output<DeliveryChannelSnapshotDeliveryPropertiesArgs>) {
        this.snapshotDeliveryProperties = value
    }

    /**
     * @param value The ARN of the SNS topic that AWS Config delivers notifications to.
     */
    @JvmName("hgsoegarkljiefmy")
    public suspend fun snsTopicArn(`value`: Output<String>) {
        this.snsTopicArn = value
    }

    /**
     * @param value The name of the delivery channel. Defaults to `default`. Changing it recreates the resource.
     */
    @JvmName("jyuygfcmgkbewfuw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the S3 bucket used to store the configuration history.
     */
    @JvmName("kruhpsxcrqejbvse")
    public suspend fun s3BucketName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3BucketName = mapped
    }

    /**
     * @param value The prefix for the specified S3 bucket.
     */
    @JvmName("rumsounpupxaiqvi")
    public suspend fun s3KeyPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3KeyPrefix = mapped
    }

    /**
     * @param value The ARN of the AWS KMS key used to encrypt objects delivered by AWS Config. Must belong to the same Region as the destination S3 bucket.
     */
    @JvmName("rssxubjfvdlwpwsm")
    public suspend fun s3KmsKeyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3KmsKeyArn = mapped
    }

    /**
     * @param value Options for how AWS Config delivers configuration snapshots. See below
     */
    @JvmName("ymmobryqxynqeamn")
    public suspend
    fun snapshotDeliveryProperties(`value`: DeliveryChannelSnapshotDeliveryPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotDeliveryProperties = mapped
    }

    /**
     * @param argument Options for how AWS Config delivers configuration snapshots. See below
     */
    @JvmName("vpcbhhksrvkoxoqp")
    public suspend
    fun snapshotDeliveryProperties(argument: suspend DeliveryChannelSnapshotDeliveryPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DeliveryChannelSnapshotDeliveryPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.snapshotDeliveryProperties = mapped
    }

    /**
     * @param value The ARN of the SNS topic that AWS Config delivers notifications to.
     */
    @JvmName("mjnqlloostoogkde")
    public suspend fun snsTopicArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snsTopicArn = mapped
    }

    internal fun build(): DeliveryChannelArgs = DeliveryChannelArgs(
        name = name,
        s3BucketName = s3BucketName,
        s3KeyPrefix = s3KeyPrefix,
        s3KmsKeyArn = s3KmsKeyArn,
        snapshotDeliveryProperties = snapshotDeliveryProperties,
        snsTopicArn = snsTopicArn,
    )
}
