@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin

import com.pulumi.aws.cfg.OrganizationCustomPolicyRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Manages a Config Organization Custom Policy Rule. More information about these rules can be found in the [Enabling AWS Config Rules Across all Accounts in Your Organization](https://docs&#46;aws&#46;amazon&#46;com/config/latest/developerguide/config-rule-multi-account-deployment&#46;html) and [AWS Config Managed Rules](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html) documentation. For working with Organization Managed Rules (those invoking an AWS managed rule), see the `aws_config_organization_managed__rule` resource.
 * > **NOTE:** This resource must be created in the Organization master account and rules will include the master account unless its ID is added to the `excluded_accounts` argument.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cfg.OrganizationCustomPolicyRule;
 * import com.pulumi.aws.cfg.OrganizationCustomPolicyRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new OrganizationCustomPolicyRule("example", OrganizationCustomPolicyRuleArgs.builder()
 *             .policyRuntime("guard-2.x.x")
 *             .policyText("""
 *   let status = ['ACTIVE']
 *   rule tableisactive when
 *       resourceType == "AWS::DynamoDB::Table" {
 *       configuration.tableStatus == %status
 *   }
 *   rule checkcompliance when
 *       resourceType == "AWS::DynamoDB::Table"
 *       tableisactive {
 *           let pitr = supplementaryConfiguration.ContinuousBackupsDescription.pointInTimeRecoveryDescription.pointInTimeRecoveryStatus
 *           %pitr == "ENABLED"
 *       }
 *             """)
 *             .resourceTypesScopes("AWS::DynamoDB::Table")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import a Config Organization Custom Policy Rule using the `name` argument. For example:
 * ```sh
 *  $ pulumi import aws:cfg/organizationCustomPolicyRule:OrganizationCustomPolicyRule example example_rule_name
 * ```
 * @property debugLogDeliveryAccounts List of AWS account identifiers to exclude from the rule
 * @property description Description of the rule
 * @property excludedAccounts List of AWS account identifiers to exclude from the rule
 * @property inputParameters A string in JSON format that is passed to the AWS Config Rule Lambda Function
 * @property maximumExecutionFrequency Maximum frequency with which AWS Config runs evaluations for a rule, if the rule is triggered at a periodic frequency. Defaults to `TwentyFour_Hours` for periodic frequency triggered rules. Valid values: `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, or `TwentyFour_Hours`.
 * @property name name of the rule
 * @property policyRuntime runtime system for your organization AWS Config Custom Policy rules
 * @property policyText policy definition containing the logic for your organization AWS Config Custom Policy rule
 * @property resourceIdScope Identifier of the AWS resource to evaluate
 * @property resourceTypesScopes List of types of AWS resources to evaluate
 * @property tagKeyScope Tag key of AWS resources to evaluate
 * @property tagValueScope Tag value of AWS resources to evaluate
 * @property triggerTypes List of notification types that trigger AWS Config to run an evaluation for the rule. Valid values: `ConfigurationItemChangeNotification`, `OversizedConfigurationItemChangeNotification`
 * The following arguments are optional:
 */
public data class OrganizationCustomPolicyRuleArgs(
    public val debugLogDeliveryAccounts: Output<List<String>>? = null,
    public val description: Output<String>? = null,
    public val excludedAccounts: Output<List<String>>? = null,
    public val inputParameters: Output<String>? = null,
    public val maximumExecutionFrequency: Output<String>? = null,
    public val name: Output<String>? = null,
    public val policyRuntime: Output<String>? = null,
    public val policyText: Output<String>? = null,
    public val resourceIdScope: Output<String>? = null,
    public val resourceTypesScopes: Output<List<String>>? = null,
    public val tagKeyScope: Output<String>? = null,
    public val tagValueScope: Output<String>? = null,
    public val triggerTypes: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.cfg.OrganizationCustomPolicyRuleArgs> {
    override fun toJava(): com.pulumi.aws.cfg.OrganizationCustomPolicyRuleArgs =
        com.pulumi.aws.cfg.OrganizationCustomPolicyRuleArgs.builder()
            .debugLogDeliveryAccounts(
                debugLogDeliveryAccounts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .excludedAccounts(excludedAccounts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .inputParameters(inputParameters?.applyValue({ args0 -> args0 }))
            .maximumExecutionFrequency(maximumExecutionFrequency?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .policyRuntime(policyRuntime?.applyValue({ args0 -> args0 }))
            .policyText(policyText?.applyValue({ args0 -> args0 }))
            .resourceIdScope(resourceIdScope?.applyValue({ args0 -> args0 }))
            .resourceTypesScopes(resourceTypesScopes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tagKeyScope(tagKeyScope?.applyValue({ args0 -> args0 }))
            .tagValueScope(tagValueScope?.applyValue({ args0 -> args0 }))
            .triggerTypes(triggerTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [OrganizationCustomPolicyRuleArgs].
 */
@PulumiTagMarker
public class OrganizationCustomPolicyRuleArgsBuilder internal constructor() {
    private var debugLogDeliveryAccounts: Output<List<String>>? = null

    private var description: Output<String>? = null

    private var excludedAccounts: Output<List<String>>? = null

    private var inputParameters: Output<String>? = null

    private var maximumExecutionFrequency: Output<String>? = null

    private var name: Output<String>? = null

    private var policyRuntime: Output<String>? = null

    private var policyText: Output<String>? = null

    private var resourceIdScope: Output<String>? = null

    private var resourceTypesScopes: Output<List<String>>? = null

    private var tagKeyScope: Output<String>? = null

    private var tagValueScope: Output<String>? = null

    private var triggerTypes: Output<List<String>>? = null

    /**
     * @param value List of AWS account identifiers to exclude from the rule
     */
    @JvmName("hcabbryqemjdessj")
    public suspend fun debugLogDeliveryAccounts(`value`: Output<List<String>>) {
        this.debugLogDeliveryAccounts = value
    }

    @JvmName("dcriwqrvafkhbqca")
    public suspend fun debugLogDeliveryAccounts(vararg values: Output<String>) {
        this.debugLogDeliveryAccounts = Output.all(values.asList())
    }

    /**
     * @param values List of AWS account identifiers to exclude from the rule
     */
    @JvmName("dfurrmeuaaidrvqu")
    public suspend fun debugLogDeliveryAccounts(values: List<Output<String>>) {
        this.debugLogDeliveryAccounts = Output.all(values)
    }

    /**
     * @param value Description of the rule
     */
    @JvmName("iguxnfhcrdgmgpaj")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value List of AWS account identifiers to exclude from the rule
     */
    @JvmName("ebapewrntlapvbrr")
    public suspend fun excludedAccounts(`value`: Output<List<String>>) {
        this.excludedAccounts = value
    }

    @JvmName("dxubwxumciyihsfj")
    public suspend fun excludedAccounts(vararg values: Output<String>) {
        this.excludedAccounts = Output.all(values.asList())
    }

    /**
     * @param values List of AWS account identifiers to exclude from the rule
     */
    @JvmName("cidcnpgepgkwxonu")
    public suspend fun excludedAccounts(values: List<Output<String>>) {
        this.excludedAccounts = Output.all(values)
    }

    /**
     * @param value A string in JSON format that is passed to the AWS Config Rule Lambda Function
     */
    @JvmName("yxgpuweqfcqidpbp")
    public suspend fun inputParameters(`value`: Output<String>) {
        this.inputParameters = value
    }

    /**
     * @param value Maximum frequency with which AWS Config runs evaluations for a rule, if the rule is triggered at a periodic frequency. Defaults to `TwentyFour_Hours` for periodic frequency triggered rules. Valid values: `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, or `TwentyFour_Hours`.
     */
    @JvmName("yxatpphwiwxrhscw")
    public suspend fun maximumExecutionFrequency(`value`: Output<String>) {
        this.maximumExecutionFrequency = value
    }

    /**
     * @param value name of the rule
     */
    @JvmName("lxdwrjalurpugqku")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value runtime system for your organization AWS Config Custom Policy rules
     */
    @JvmName("seavnaorgvjxjjcj")
    public suspend fun policyRuntime(`value`: Output<String>) {
        this.policyRuntime = value
    }

    /**
     * @param value policy definition containing the logic for your organization AWS Config Custom Policy rule
     */
    @JvmName("oecrwrryrontrffx")
    public suspend fun policyText(`value`: Output<String>) {
        this.policyText = value
    }

    /**
     * @param value Identifier of the AWS resource to evaluate
     */
    @JvmName("lfopjwhfobpcecod")
    public suspend fun resourceIdScope(`value`: Output<String>) {
        this.resourceIdScope = value
    }

    /**
     * @param value List of types of AWS resources to evaluate
     */
    @JvmName("apnelrjhenoqqrxs")
    public suspend fun resourceTypesScopes(`value`: Output<List<String>>) {
        this.resourceTypesScopes = value
    }

    @JvmName("wkhseemxdkhjjydp")
    public suspend fun resourceTypesScopes(vararg values: Output<String>) {
        this.resourceTypesScopes = Output.all(values.asList())
    }

    /**
     * @param values List of types of AWS resources to evaluate
     */
    @JvmName("xmqtixwvhoghqqah")
    public suspend fun resourceTypesScopes(values: List<Output<String>>) {
        this.resourceTypesScopes = Output.all(values)
    }

    /**
     * @param value Tag key of AWS resources to evaluate
     */
    @JvmName("eypemglxgmpgcwrc")
    public suspend fun tagKeyScope(`value`: Output<String>) {
        this.tagKeyScope = value
    }

    /**
     * @param value Tag value of AWS resources to evaluate
     */
    @JvmName("prqadbclghwkpqfq")
    public suspend fun tagValueScope(`value`: Output<String>) {
        this.tagValueScope = value
    }

    /**
     * @param value List of notification types that trigger AWS Config to run an evaluation for the rule. Valid values: `ConfigurationItemChangeNotification`, `OversizedConfigurationItemChangeNotification`
     * The following arguments are optional:
     */
    @JvmName("hbrygimogedsfnme")
    public suspend fun triggerTypes(`value`: Output<List<String>>) {
        this.triggerTypes = value
    }

    @JvmName("exlhkwfqadtmjtoc")
    public suspend fun triggerTypes(vararg values: Output<String>) {
        this.triggerTypes = Output.all(values.asList())
    }

    /**
     * @param values List of notification types that trigger AWS Config to run an evaluation for the rule. Valid values: `ConfigurationItemChangeNotification`, `OversizedConfigurationItemChangeNotification`
     * The following arguments are optional:
     */
    @JvmName("hgblnikydfkmepxn")
    public suspend fun triggerTypes(values: List<Output<String>>) {
        this.triggerTypes = Output.all(values)
    }

    /**
     * @param value List of AWS account identifiers to exclude from the rule
     */
    @JvmName("knfrewjkxrikgltu")
    public suspend fun debugLogDeliveryAccounts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.debugLogDeliveryAccounts = mapped
    }

    /**
     * @param values List of AWS account identifiers to exclude from the rule
     */
    @JvmName("sygxcrtuetqhgqiv")
    public suspend fun debugLogDeliveryAccounts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.debugLogDeliveryAccounts = mapped
    }

    /**
     * @param value Description of the rule
     */
    @JvmName("gsqqvsfppvidjkpt")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value List of AWS account identifiers to exclude from the rule
     */
    @JvmName("nmoqkgdlakefpwbs")
    public suspend fun excludedAccounts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludedAccounts = mapped
    }

    /**
     * @param values List of AWS account identifiers to exclude from the rule
     */
    @JvmName("vgqgwfovqcmpcytv")
    public suspend fun excludedAccounts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludedAccounts = mapped
    }

    /**
     * @param value A string in JSON format that is passed to the AWS Config Rule Lambda Function
     */
    @JvmName("vhwiwbeynvuwpkcf")
    public suspend fun inputParameters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputParameters = mapped
    }

    /**
     * @param value Maximum frequency with which AWS Config runs evaluations for a rule, if the rule is triggered at a periodic frequency. Defaults to `TwentyFour_Hours` for periodic frequency triggered rules. Valid values: `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, or `TwentyFour_Hours`.
     */
    @JvmName("lqeuftgaqsnklpnl")
    public suspend fun maximumExecutionFrequency(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumExecutionFrequency = mapped
    }

    /**
     * @param value name of the rule
     */
    @JvmName("vfvofephvhpplhrf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value runtime system for your organization AWS Config Custom Policy rules
     */
    @JvmName("tihsmxxvtuqavwju")
    public suspend fun policyRuntime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyRuntime = mapped
    }

    /**
     * @param value policy definition containing the logic for your organization AWS Config Custom Policy rule
     */
    @JvmName("suvvgiejsctcbmjh")
    public suspend fun policyText(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyText = mapped
    }

    /**
     * @param value Identifier of the AWS resource to evaluate
     */
    @JvmName("asefyovtomfchdus")
    public suspend fun resourceIdScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceIdScope = mapped
    }

    /**
     * @param value List of types of AWS resources to evaluate
     */
    @JvmName("ttwhudsklypntlom")
    public suspend fun resourceTypesScopes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceTypesScopes = mapped
    }

    /**
     * @param values List of types of AWS resources to evaluate
     */
    @JvmName("jtpvtfseokyxjxpm")
    public suspend fun resourceTypesScopes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTypesScopes = mapped
    }

    /**
     * @param value Tag key of AWS resources to evaluate
     */
    @JvmName("ldyembytvothqccy")
    public suspend fun tagKeyScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagKeyScope = mapped
    }

    /**
     * @param value Tag value of AWS resources to evaluate
     */
    @JvmName("fgeviglnumnrwugt")
    public suspend fun tagValueScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagValueScope = mapped
    }

    /**
     * @param value List of notification types that trigger AWS Config to run an evaluation for the rule. Valid values: `ConfigurationItemChangeNotification`, `OversizedConfigurationItemChangeNotification`
     * The following arguments are optional:
     */
    @JvmName("glyklewfuddmhyax")
    public suspend fun triggerTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.triggerTypes = mapped
    }

    /**
     * @param values List of notification types that trigger AWS Config to run an evaluation for the rule. Valid values: `ConfigurationItemChangeNotification`, `OversizedConfigurationItemChangeNotification`
     * The following arguments are optional:
     */
    @JvmName("lrimyavlbgkspdru")
    public suspend fun triggerTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggerTypes = mapped
    }

    internal fun build(): OrganizationCustomPolicyRuleArgs = OrganizationCustomPolicyRuleArgs(
        debugLogDeliveryAccounts = debugLogDeliveryAccounts,
        description = description,
        excludedAccounts = excludedAccounts,
        inputParameters = inputParameters,
        maximumExecutionFrequency = maximumExecutionFrequency,
        name = name,
        policyRuntime = policyRuntime,
        policyText = policyText,
        resourceIdScope = resourceIdScope,
        resourceTypesScopes = resourceTypesScopes,
        tagKeyScope = tagKeyScope,
        tagValueScope = tagValueScope,
        triggerTypes = triggerTypes,
    )
}
