@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [OrganizationCustomRule].
 */
@PulumiTagMarker
public class OrganizationCustomRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OrganizationCustomRuleArgs = OrganizationCustomRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OrganizationCustomRuleArgsBuilder.() -> Unit) {
        val builder = OrganizationCustomRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): OrganizationCustomRule {
        val builtJavaResource = com.pulumi.aws.cfg.OrganizationCustomRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return OrganizationCustomRule(builtJavaResource)
    }
}

/**
 * Manages a Config Organization Custom Rule. More information about these rules can be found in the [Enabling AWS Config Rules Across all Accounts in Your Organization](https://docs&#46;aws&#46;amazon&#46;com/config/latest/developerguide/config-rule-multi-account-deployment&#46;html) and [AWS Config Managed Rules](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html) documentation. For working with Organization Managed Rules (those invoking an AWS managed rule), see the `aws_config_organization_managed__rule` resource.
 * > **NOTE:** This resource must be created in the Organization master account and rules will include the master account unless its ID is added to the `excluded_accounts` argument.
 * > **NOTE:** The proper Lambda permission to allow the AWS Config service invoke the Lambda Function must be in place before the rule will successfully create or update. See also the `aws.lambda.Permission` resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.Permission;
 * import com.pulumi.aws.lambda.PermissionArgs;
 * import com.pulumi.aws.organizations.Organization;
 * import com.pulumi.aws.organizations.OrganizationArgs;
 * import com.pulumi.aws.cfg.OrganizationCustomRule;
 * import com.pulumi.aws.cfg.OrganizationCustomRuleArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var examplePermission = new Permission("examplePermission", PermissionArgs.builder()
 *             .action("lambda:InvokeFunction")
 *             .function(aws_lambda_function.example().arn())
 *             .principal("config.amazonaws.com")
 *             .build());
 *         var exampleOrganization = new Organization("exampleOrganization", OrganizationArgs.builder()
 *             .awsServiceAccessPrincipals("config-multiaccountsetup.amazonaws.com")
 *             .featureSet("ALL")
 *             .build());
 *         var exampleOrganizationCustomRule = new OrganizationCustomRule("exampleOrganizationCustomRule", OrganizationCustomRuleArgs.builder()
 *             .lambdaFunctionArn(aws_lambda_function.example().arn())
 *             .triggerTypes("ConfigurationItemChangeNotification")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(
 *                     examplePermission,
 *                     exampleOrganization)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Config Organization Custom Rules using the name. For example:
 * ```sh
 *  $ pulumi import aws:cfg/organizationCustomRule:OrganizationCustomRule example example
 * ```
 *
 */
public class OrganizationCustomRule internal constructor(
    override val javaResource: com.pulumi.aws.cfg.OrganizationCustomRule,
) : KotlinCustomResource(javaResource, OrganizationCustomRuleMapper) {
    /**
     * Amazon Resource Name (ARN) of the rule
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Description of the rule
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of AWS account identifiers to exclude from the rule
     */
    public val excludedAccounts: Output<List<String>>?
        get() = javaResource.excludedAccounts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * A string in JSON format that is passed to the AWS Config Rule Lambda Function
     */
    public val inputParameters: Output<String>?
        get() = javaResource.inputParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Amazon Resource Name (ARN) of the rule Lambda Function
     */
    public val lambdaFunctionArn: Output<String>
        get() = javaResource.lambdaFunctionArn().applyValue({ args0 -> args0 })

    /**
     * The maximum frequency with which AWS Config runs evaluations for a rule, if the rule is triggered at a periodic frequency. Defaults to `TwentyFour_Hours` for periodic frequency triggered rules. Valid values: `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, or `TwentyFour_Hours`.
     */
    public val maximumExecutionFrequency: Output<String>?
        get() = javaResource.maximumExecutionFrequency().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the rule
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Identifier of the AWS resource to evaluate
     */
    public val resourceIdScope: Output<String>?
        get() = javaResource.resourceIdScope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of types of AWS resources to evaluate
     */
    public val resourceTypesScopes: Output<List<String>>?
        get() = javaResource.resourceTypesScopes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Tag key of AWS resources to evaluate
     */
    public val tagKeyScope: Output<String>?
        get() = javaResource.tagKeyScope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Tag value of AWS resources to evaluate
     */
    public val tagValueScope: Output<String>?
        get() = javaResource.tagValueScope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of notification types that trigger AWS Config to run an evaluation for the rule. Valid values: `ConfigurationItemChangeNotification`, `OversizedConfigurationItemChangeNotification`, and `ScheduledNotification`
     */
    public val triggerTypes: Output<List<String>>
        get() = javaResource.triggerTypes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object OrganizationCustomRuleMapper : ResourceMapper<OrganizationCustomRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cfg.OrganizationCustomRule::class == javaResource::class

    override fun map(javaResource: Resource): OrganizationCustomRule =
        OrganizationCustomRule(javaResource as com.pulumi.aws.cfg.OrganizationCustomRule)
}

/**
 * @see [OrganizationCustomRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OrganizationCustomRule].
 */
public suspend fun organizationCustomRule(
    name: String,
    block: suspend OrganizationCustomRuleResourceBuilder.() -> Unit,
): OrganizationCustomRule {
    val builder = OrganizationCustomRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OrganizationCustomRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun organizationCustomRule(name: String): OrganizationCustomRule {
    val builder = OrganizationCustomRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
