@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin

import com.pulumi.aws.cfg.OrganizationCustomRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Manages a Config Organization Custom Rule. More information about these rules can be found in the [Enabling AWS Config Rules Across all Accounts in Your Organization](https://docs&#46;aws&#46;amazon&#46;com/config/latest/developerguide/config-rule-multi-account-deployment&#46;html) and [AWS Config Managed Rules](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html) documentation. For working with Organization Managed Rules (those invoking an AWS managed rule), see the `aws_config_organization_managed__rule` resource.
 * > **NOTE:** This resource must be created in the Organization master account and rules will include the master account unless its ID is added to the `excluded_accounts` argument.
 * > **NOTE:** The proper Lambda permission to allow the AWS Config service invoke the Lambda Function must be in place before the rule will successfully create or update. See also the `aws.lambda.Permission` resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.Permission;
 * import com.pulumi.aws.lambda.PermissionArgs;
 * import com.pulumi.aws.organizations.Organization;
 * import com.pulumi.aws.organizations.OrganizationArgs;
 * import com.pulumi.aws.cfg.OrganizationCustomRule;
 * import com.pulumi.aws.cfg.OrganizationCustomRuleArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var examplePermission = new Permission("examplePermission", PermissionArgs.builder()
 *             .action("lambda:InvokeFunction")
 *             .function(aws_lambda_function.example().arn())
 *             .principal("config.amazonaws.com")
 *             .build());
 *         var exampleOrganization = new Organization("exampleOrganization", OrganizationArgs.builder()
 *             .awsServiceAccessPrincipals("config-multiaccountsetup.amazonaws.com")
 *             .featureSet("ALL")
 *             .build());
 *         var exampleOrganizationCustomRule = new OrganizationCustomRule("exampleOrganizationCustomRule", OrganizationCustomRuleArgs.builder()
 *             .lambdaFunctionArn(aws_lambda_function.example().arn())
 *             .triggerTypes("ConfigurationItemChangeNotification")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(
 *                     examplePermission,
 *                     exampleOrganization)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Config Organization Custom Rules using the name. For example:
 * ```sh
 *  $ pulumi import aws:cfg/organizationCustomRule:OrganizationCustomRule example example
 * ```
 * @property description Description of the rule
 * @property excludedAccounts List of AWS account identifiers to exclude from the rule
 * @property inputParameters A string in JSON format that is passed to the AWS Config Rule Lambda Function
 * @property lambdaFunctionArn Amazon Resource Name (ARN) of the rule Lambda Function
 * @property maximumExecutionFrequency The maximum frequency with which AWS Config runs evaluations for a rule, if the rule is triggered at a periodic frequency. Defaults to `TwentyFour_Hours` for periodic frequency triggered rules. Valid values: `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, or `TwentyFour_Hours`.
 * @property name The name of the rule
 * @property resourceIdScope Identifier of the AWS resource to evaluate
 * @property resourceTypesScopes List of types of AWS resources to evaluate
 * @property tagKeyScope Tag key of AWS resources to evaluate
 * @property tagValueScope Tag value of AWS resources to evaluate
 * @property triggerTypes List of notification types that trigger AWS Config to run an evaluation for the rule. Valid values: `ConfigurationItemChangeNotification`, `OversizedConfigurationItemChangeNotification`, and `ScheduledNotification`
 */
public data class OrganizationCustomRuleArgs(
    public val description: Output<String>? = null,
    public val excludedAccounts: Output<List<String>>? = null,
    public val inputParameters: Output<String>? = null,
    public val lambdaFunctionArn: Output<String>? = null,
    public val maximumExecutionFrequency: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceIdScope: Output<String>? = null,
    public val resourceTypesScopes: Output<List<String>>? = null,
    public val tagKeyScope: Output<String>? = null,
    public val tagValueScope: Output<String>? = null,
    public val triggerTypes: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.cfg.OrganizationCustomRuleArgs> {
    override fun toJava(): com.pulumi.aws.cfg.OrganizationCustomRuleArgs =
        com.pulumi.aws.cfg.OrganizationCustomRuleArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .excludedAccounts(excludedAccounts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .inputParameters(inputParameters?.applyValue({ args0 -> args0 }))
            .lambdaFunctionArn(lambdaFunctionArn?.applyValue({ args0 -> args0 }))
            .maximumExecutionFrequency(maximumExecutionFrequency?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceIdScope(resourceIdScope?.applyValue({ args0 -> args0 }))
            .resourceTypesScopes(resourceTypesScopes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tagKeyScope(tagKeyScope?.applyValue({ args0 -> args0 }))
            .tagValueScope(tagValueScope?.applyValue({ args0 -> args0 }))
            .triggerTypes(triggerTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [OrganizationCustomRuleArgs].
 */
@PulumiTagMarker
public class OrganizationCustomRuleArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var excludedAccounts: Output<List<String>>? = null

    private var inputParameters: Output<String>? = null

    private var lambdaFunctionArn: Output<String>? = null

    private var maximumExecutionFrequency: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceIdScope: Output<String>? = null

    private var resourceTypesScopes: Output<List<String>>? = null

    private var tagKeyScope: Output<String>? = null

    private var tagValueScope: Output<String>? = null

    private var triggerTypes: Output<List<String>>? = null

    /**
     * @param value Description of the rule
     */
    @JvmName("ohxkmfqxawtgskyp")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value List of AWS account identifiers to exclude from the rule
     */
    @JvmName("yohdwrwwdtumrkgd")
    public suspend fun excludedAccounts(`value`: Output<List<String>>) {
        this.excludedAccounts = value
    }

    @JvmName("ixmjjknpaodksrja")
    public suspend fun excludedAccounts(vararg values: Output<String>) {
        this.excludedAccounts = Output.all(values.asList())
    }

    /**
     * @param values List of AWS account identifiers to exclude from the rule
     */
    @JvmName("itwrbywdxnrtjhah")
    public suspend fun excludedAccounts(values: List<Output<String>>) {
        this.excludedAccounts = Output.all(values)
    }

    /**
     * @param value A string in JSON format that is passed to the AWS Config Rule Lambda Function
     */
    @JvmName("gwphfffmttgysseu")
    public suspend fun inputParameters(`value`: Output<String>) {
        this.inputParameters = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the rule Lambda Function
     */
    @JvmName("ddarglqhgsbykcqu")
    public suspend fun lambdaFunctionArn(`value`: Output<String>) {
        this.lambdaFunctionArn = value
    }

    /**
     * @param value The maximum frequency with which AWS Config runs evaluations for a rule, if the rule is triggered at a periodic frequency. Defaults to `TwentyFour_Hours` for periodic frequency triggered rules. Valid values: `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, or `TwentyFour_Hours`.
     */
    @JvmName("ptaceehpkfdkflds")
    public suspend fun maximumExecutionFrequency(`value`: Output<String>) {
        this.maximumExecutionFrequency = value
    }

    /**
     * @param value The name of the rule
     */
    @JvmName("lxjnmknefdrhikhe")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Identifier of the AWS resource to evaluate
     */
    @JvmName("kypcslhktcnwvjmb")
    public suspend fun resourceIdScope(`value`: Output<String>) {
        this.resourceIdScope = value
    }

    /**
     * @param value List of types of AWS resources to evaluate
     */
    @JvmName("pojfxmssmoaqqosc")
    public suspend fun resourceTypesScopes(`value`: Output<List<String>>) {
        this.resourceTypesScopes = value
    }

    @JvmName("pybesebmtbdvfjnx")
    public suspend fun resourceTypesScopes(vararg values: Output<String>) {
        this.resourceTypesScopes = Output.all(values.asList())
    }

    /**
     * @param values List of types of AWS resources to evaluate
     */
    @JvmName("kgslnbfhgrsfjknh")
    public suspend fun resourceTypesScopes(values: List<Output<String>>) {
        this.resourceTypesScopes = Output.all(values)
    }

    /**
     * @param value Tag key of AWS resources to evaluate
     */
    @JvmName("wnmbubaoaivyceya")
    public suspend fun tagKeyScope(`value`: Output<String>) {
        this.tagKeyScope = value
    }

    /**
     * @param value Tag value of AWS resources to evaluate
     */
    @JvmName("spmneyqpbdiebixe")
    public suspend fun tagValueScope(`value`: Output<String>) {
        this.tagValueScope = value
    }

    /**
     * @param value List of notification types that trigger AWS Config to run an evaluation for the rule. Valid values: `ConfigurationItemChangeNotification`, `OversizedConfigurationItemChangeNotification`, and `ScheduledNotification`
     */
    @JvmName("xrofxfpeesvpkysa")
    public suspend fun triggerTypes(`value`: Output<List<String>>) {
        this.triggerTypes = value
    }

    @JvmName("rgjdmdmeforylfsi")
    public suspend fun triggerTypes(vararg values: Output<String>) {
        this.triggerTypes = Output.all(values.asList())
    }

    /**
     * @param values List of notification types that trigger AWS Config to run an evaluation for the rule. Valid values: `ConfigurationItemChangeNotification`, `OversizedConfigurationItemChangeNotification`, and `ScheduledNotification`
     */
    @JvmName("fxcycxdagqxawxoo")
    public suspend fun triggerTypes(values: List<Output<String>>) {
        this.triggerTypes = Output.all(values)
    }

    /**
     * @param value Description of the rule
     */
    @JvmName("lkemhgdicioyxisq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value List of AWS account identifiers to exclude from the rule
     */
    @JvmName("aokqadnjwgdrriju")
    public suspend fun excludedAccounts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludedAccounts = mapped
    }

    /**
     * @param values List of AWS account identifiers to exclude from the rule
     */
    @JvmName("sqhcpfyjtmbuukjw")
    public suspend fun excludedAccounts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludedAccounts = mapped
    }

    /**
     * @param value A string in JSON format that is passed to the AWS Config Rule Lambda Function
     */
    @JvmName("fujifrxpqsrlouqq")
    public suspend fun inputParameters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputParameters = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the rule Lambda Function
     */
    @JvmName("ejgkoxciieithlgb")
    public suspend fun lambdaFunctionArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lambdaFunctionArn = mapped
    }

    /**
     * @param value The maximum frequency with which AWS Config runs evaluations for a rule, if the rule is triggered at a periodic frequency. Defaults to `TwentyFour_Hours` for periodic frequency triggered rules. Valid values: `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, or `TwentyFour_Hours`.
     */
    @JvmName("khxdqlmubwumekpd")
    public suspend fun maximumExecutionFrequency(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumExecutionFrequency = mapped
    }

    /**
     * @param value The name of the rule
     */
    @JvmName("qpfmqwukbtwpsfnf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Identifier of the AWS resource to evaluate
     */
    @JvmName("abgsegkcmvbwltwl")
    public suspend fun resourceIdScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceIdScope = mapped
    }

    /**
     * @param value List of types of AWS resources to evaluate
     */
    @JvmName("ebxcstcqtoqbkbjb")
    public suspend fun resourceTypesScopes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceTypesScopes = mapped
    }

    /**
     * @param values List of types of AWS resources to evaluate
     */
    @JvmName("ubtudehevpnolijc")
    public suspend fun resourceTypesScopes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTypesScopes = mapped
    }

    /**
     * @param value Tag key of AWS resources to evaluate
     */
    @JvmName("bxhuatussiunjdgq")
    public suspend fun tagKeyScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagKeyScope = mapped
    }

    /**
     * @param value Tag value of AWS resources to evaluate
     */
    @JvmName("oeuhyjyagqxfhlnd")
    public suspend fun tagValueScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagValueScope = mapped
    }

    /**
     * @param value List of notification types that trigger AWS Config to run an evaluation for the rule. Valid values: `ConfigurationItemChangeNotification`, `OversizedConfigurationItemChangeNotification`, and `ScheduledNotification`
     */
    @JvmName("jqypcgjeulloscmq")
    public suspend fun triggerTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.triggerTypes = mapped
    }

    /**
     * @param values List of notification types that trigger AWS Config to run an evaluation for the rule. Valid values: `ConfigurationItemChangeNotification`, `OversizedConfigurationItemChangeNotification`, and `ScheduledNotification`
     */
    @JvmName("uxmhdcikbhsaeofj")
    public suspend fun triggerTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggerTypes = mapped
    }

    internal fun build(): OrganizationCustomRuleArgs = OrganizationCustomRuleArgs(
        description = description,
        excludedAccounts = excludedAccounts,
        inputParameters = inputParameters,
        lambdaFunctionArn = lambdaFunctionArn,
        maximumExecutionFrequency = maximumExecutionFrequency,
        name = name,
        resourceIdScope = resourceIdScope,
        resourceTypesScopes = resourceTypesScopes,
        tagKeyScope = tagKeyScope,
        tagValueScope = tagValueScope,
        triggerTypes = triggerTypes,
    )
}
