@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin

import com.pulumi.aws.cfg.kotlin.outputs.RecorderRecordingGroup
import com.pulumi.aws.cfg.kotlin.outputs.RecorderRecordingGroup.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Recorder].
 */
@PulumiTagMarker
public class RecorderResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RecorderArgs = RecorderArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RecorderArgsBuilder.() -> Unit) {
        val builder = RecorderArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Recorder {
        val builtJavaResource = com.pulumi.aws.cfg.Recorder(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Recorder(builtJavaResource)
    }
}

/**
 * Provides an AWS Config Configuration Recorder. Please note that this resource **does not start** the created recorder automatically.
 * > **Note:** _Starting_ the Configuration Recorder requires a delivery channel (while delivery channel creation requires Configuration Recorder). This is why `aws.cfg.RecorderStatus` is a separate resource.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.cfg.Recorder;
 * import com.pulumi.aws.cfg.RecorderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("config.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var role = new Role("role", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var foo = new Recorder("foo", RecorderArgs.builder()
 *             .roleArn(role.arn())
 *             .build());
 *     }
 * }
 * ```
 * ### Exclude Resources Types Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cfg.Recorder;
 * import com.pulumi.aws.cfg.RecorderArgs;
 * import com.pulumi.aws.cfg.inputs.RecorderRecordingGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new Recorder("foo", RecorderArgs.builder()
 *             .roleArn(aws_iam_role.r().arn())
 *             .recordingGroup(RecorderRecordingGroupArgs.builder()
 *                 .allSupported(false)
 *                 .exclusionByResourceTypes(RecorderRecordingGroupExclusionByResourceTypeArgs.builder()
 *                     .resourceTypes("AWS::EC2::Instance")
 *                     .build())
 *                 .recordingStrategies(RecorderRecordingGroupRecordingStrategyArgs.builder()
 *                     .useOnly("EXCLUSION_BY_RESOURCE_TYPES")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Configuration Recorder using the name. For example:
 * ```sh
 *  $ pulumi import aws:cfg/recorder:Recorder foo example
 * ```
 *
 */
public class Recorder internal constructor(
    override val javaResource: com.pulumi.aws.cfg.Recorder,
) : KotlinCustomResource(javaResource, RecorderMapper) {
    /**
     * The name of the recorder. Defaults to `default`. Changing it recreates the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Recording group - see below.
     */
    public val recordingGroup: Output<RecorderRecordingGroup>
        get() = javaResource.recordingGroup().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * Amazon Resource Name (ARN) of the IAM role. Used to make read or write requests to the delivery channel and to describe the AWS resources associated with the account. See [AWS Docs](http://docs.aws.amazon.com/config/latest/developerguide/iamrole-permissions.html) for more details.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })
}

public object RecorderMapper : ResourceMapper<Recorder> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cfg.Recorder::class == javaResource::class

    override fun map(javaResource: Resource): Recorder = Recorder(
        javaResource as
            com.pulumi.aws.cfg.Recorder,
    )
}

/**
 * @see [Recorder].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Recorder].
 */
public suspend fun recorder(name: String, block: suspend RecorderResourceBuilder.() -> Unit):
    Recorder {
    val builder = RecorderResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Recorder].
 * @param name The _unique_ name of the resulting resource.
 */
public fun recorder(name: String): Recorder {
    val builder = RecorderResourceBuilder()
    builder.name(name)
    return builder.build()
}
