@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin

import com.pulumi.aws.cfg.RecorderArgs.builder
import com.pulumi.aws.cfg.kotlin.inputs.RecorderRecordingGroupArgs
import com.pulumi.aws.cfg.kotlin.inputs.RecorderRecordingGroupArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides an AWS Config Configuration Recorder. Please note that this resource **does not start** the created recorder automatically.
 * > **Note:** _Starting_ the Configuration Recorder requires a delivery channel (while delivery channel creation requires Configuration Recorder). This is why `aws.cfg.RecorderStatus` is a separate resource.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.cfg.Recorder;
 * import com.pulumi.aws.cfg.RecorderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("config.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var role = new Role("role", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var foo = new Recorder("foo", RecorderArgs.builder()
 *             .roleArn(role.arn())
 *             .build());
 *     }
 * }
 * ```
 * ### Exclude Resources Types Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cfg.Recorder;
 * import com.pulumi.aws.cfg.RecorderArgs;
 * import com.pulumi.aws.cfg.inputs.RecorderRecordingGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new Recorder("foo", RecorderArgs.builder()
 *             .roleArn(aws_iam_role.r().arn())
 *             .recordingGroup(RecorderRecordingGroupArgs.builder()
 *                 .allSupported(false)
 *                 .exclusionByResourceTypes(RecorderRecordingGroupExclusionByResourceTypeArgs.builder()
 *                     .resourceTypes("AWS::EC2::Instance")
 *                     .build())
 *                 .recordingStrategies(RecorderRecordingGroupRecordingStrategyArgs.builder()
 *                     .useOnly("EXCLUSION_BY_RESOURCE_TYPES")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Configuration Recorder using the name. For example:
 * ```sh
 *  $ pulumi import aws:cfg/recorder:Recorder foo example
 * ```
 * @property name The name of the recorder. Defaults to `default`. Changing it recreates the resource.
 * @property recordingGroup Recording group - see below.
 * @property roleArn Amazon Resource Name (ARN) of the IAM role. Used to make read or write requests to the delivery channel and to describe the AWS resources associated with the account. See [AWS Docs](http://docs.aws.amazon.com/config/latest/developerguide/iamrole-permissions.html) for more details.
 */
public data class RecorderArgs(
    public val name: Output<String>? = null,
    public val recordingGroup: Output<RecorderRecordingGroupArgs>? = null,
    public val roleArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cfg.RecorderArgs> {
    override fun toJava(): com.pulumi.aws.cfg.RecorderArgs = com.pulumi.aws.cfg.RecorderArgs.builder()
        .name(name?.applyValue({ args0 -> args0 }))
        .recordingGroup(recordingGroup?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .roleArn(roleArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RecorderArgs].
 */
@PulumiTagMarker
public class RecorderArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var recordingGroup: Output<RecorderRecordingGroupArgs>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value The name of the recorder. Defaults to `default`. Changing it recreates the resource.
     */
    @JvmName("mipktnlklhiphyqp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Recording group - see below.
     */
    @JvmName("osnjdxxyqwucqbsv")
    public suspend fun recordingGroup(`value`: Output<RecorderRecordingGroupArgs>) {
        this.recordingGroup = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the IAM role. Used to make read or write requests to the delivery channel and to describe the AWS resources associated with the account. See [AWS Docs](http://docs.aws.amazon.com/config/latest/developerguide/iamrole-permissions.html) for more details.
     */
    @JvmName("uutbkdqyhxifolee")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The name of the recorder. Defaults to `default`. Changing it recreates the resource.
     */
    @JvmName("qlxnkldljwwarhay")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Recording group - see below.
     */
    @JvmName("koocamlegwwitvvj")
    public suspend fun recordingGroup(`value`: RecorderRecordingGroupArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recordingGroup = mapped
    }

    /**
     * @param argument Recording group - see below.
     */
    @JvmName("fyqnmpbtpvgiwkto")
    public suspend
    fun recordingGroup(argument: suspend RecorderRecordingGroupArgsBuilder.() -> Unit) {
        val toBeMapped = RecorderRecordingGroupArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.recordingGroup = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the IAM role. Used to make read or write requests to the delivery channel and to describe the AWS resources associated with the account. See [AWS Docs](http://docs.aws.amazon.com/config/latest/developerguide/iamrole-permissions.html) for more details.
     */
    @JvmName("gfcjbmqtrvpoxvoh")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): RecorderArgs = RecorderArgs(
        name = name,
        recordingGroup = recordingGroup,
        roleArn = roleArn,
    )
}
