@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RecorderStatus].
 */
@PulumiTagMarker
public class RecorderStatusResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RecorderStatusArgs = RecorderStatusArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RecorderStatusArgsBuilder.() -> Unit) {
        val builder = RecorderStatusArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RecorderStatus {
        val builtJavaResource = com.pulumi.aws.cfg.RecorderStatus(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RecorderStatus(builtJavaResource)
    }
}

/**
 * Manages status (recording / stopped) of an AWS Config Configuration Recorder.
 * > **Note:** Starting Configuration Recorder requires a Delivery Channel to be present. Use of `depends_on` (as shown below) is recommended to avoid race conditions.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.cfg.DeliveryChannel;
 * import com.pulumi.aws.cfg.DeliveryChannelArgs;
 * import com.pulumi.aws.cfg.RecorderStatus;
 * import com.pulumi.aws.cfg.RecorderStatusArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.cfg.Recorder;
 * import com.pulumi.aws.cfg.RecorderArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bucketV2 = new BucketV2("bucketV2");
 *         var fooDeliveryChannel = new DeliveryChannel("fooDeliveryChannel", DeliveryChannelArgs.builder()
 *             .s3BucketName(bucketV2.bucket())
 *             .build());
 *         var fooRecorderStatus = new RecorderStatus("fooRecorderStatus", RecorderStatusArgs.builder()
 *             .isEnabled(true)
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(fooDeliveryChannel)
 *                 .build());
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("config.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var role = new Role("role", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var rolePolicyAttachment = new RolePolicyAttachment("rolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .role(role.name())
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AWS_ConfigRole")
 *             .build());
 *         var fooRecorder = new Recorder("fooRecorder", RecorderArgs.builder()
 *             .roleArn(role.arn())
 *             .build());
 *         final var policyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("s3:*")
 *                 .resources(
 *                     bucketV2.arn(),
 *                     bucketV2.arn().applyValue(arn -> String.format("%s/*", arn)))
 *                 .build())
 *             .build());
 *         var rolePolicy = new RolePolicy("rolePolicy", RolePolicyArgs.builder()
 *             .role(role.id())
 *             .policy(policyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(policyDocument -> policyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Configuration Recorder Status using the name of the Configuration Recorder. For example:
 * ```sh
 *  $ pulumi import aws:cfg/recorderStatus:RecorderStatus foo example
 * ```
 * */
 */
public class RecorderStatus internal constructor(
    override val javaResource: com.pulumi.aws.cfg.RecorderStatus,
) : KotlinCustomResource(javaResource, RecorderStatusMapper) {
    /**
     * Whether the configuration recorder should be enabled or disabled.
     */
    public val isEnabled: Output<Boolean>
        get() = javaResource.isEnabled().applyValue({ args0 -> args0 })

    /**
     * The name of the recorder
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object RecorderStatusMapper : ResourceMapper<RecorderStatus> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cfg.RecorderStatus::class == javaResource::class

    override fun map(javaResource: Resource): RecorderStatus = RecorderStatus(
        javaResource as
            com.pulumi.aws.cfg.RecorderStatus,
    )
}

/**
 * @see [RecorderStatus].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RecorderStatus].
 */
public suspend fun recorderStatus(
    name: String,
    block: suspend RecorderStatusResourceBuilder.() -> Unit,
): RecorderStatus {
    val builder = RecorderStatusResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RecorderStatus].
 * @param name The _unique_ name of the resulting resource.
 */
public fun recorderStatus(name: String): RecorderStatus {
    val builder = RecorderStatusResourceBuilder()
    builder.name(name)
    return builder.build()
}
