@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin

import com.pulumi.aws.cfg.RecorderStatusArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages status (recording / stopped) of an AWS Config Configuration Recorder.
 * > **Note:** Starting Configuration Recorder requires a Delivery Channel to be present. Use of `depends_on` (as shown below) is recommended to avoid race conditions.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.cfg.DeliveryChannel;
 * import com.pulumi.aws.cfg.DeliveryChannelArgs;
 * import com.pulumi.aws.cfg.RecorderStatus;
 * import com.pulumi.aws.cfg.RecorderStatusArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.cfg.Recorder;
 * import com.pulumi.aws.cfg.RecorderArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bucketV2 = new BucketV2("bucketV2");
 *         var fooDeliveryChannel = new DeliveryChannel("fooDeliveryChannel", DeliveryChannelArgs.builder()
 *             .s3BucketName(bucketV2.bucket())
 *             .build());
 *         var fooRecorderStatus = new RecorderStatus("fooRecorderStatus", RecorderStatusArgs.builder()
 *             .isEnabled(true)
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(fooDeliveryChannel)
 *                 .build());
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("config.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var role = new Role("role", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var rolePolicyAttachment = new RolePolicyAttachment("rolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .role(role.name())
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AWS_ConfigRole")
 *             .build());
 *         var fooRecorder = new Recorder("fooRecorder", RecorderArgs.builder()
 *             .roleArn(role.arn())
 *             .build());
 *         final var policyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("s3:*")
 *                 .resources(
 *                     bucketV2.arn(),
 *                     bucketV2.arn().applyValue(arn -> String.format("%s/*", arn)))
 *                 .build())
 *             .build());
 *         var rolePolicy = new RolePolicy("rolePolicy", RolePolicyArgs.builder()
 *             .role(role.id())
 *             .policy(policyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(policyDocument -> policyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Configuration Recorder Status using the name of the Configuration Recorder. For example:
 * ```sh
 *  $ pulumi import aws:cfg/recorderStatus:RecorderStatus foo example
 * ```
 * @property isEnabled Whether the configuration recorder should be enabled or disabled.
 * @property name The name of the recorder
 * */
 */
public data class RecorderStatusArgs(
    public val isEnabled: Output<Boolean>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cfg.RecorderStatusArgs> {
    override fun toJava(): com.pulumi.aws.cfg.RecorderStatusArgs =
        com.pulumi.aws.cfg.RecorderStatusArgs.builder()
            .isEnabled(isEnabled?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RecorderStatusArgs].
 */
@PulumiTagMarker
public class RecorderStatusArgsBuilder internal constructor() {
    private var isEnabled: Output<Boolean>? = null

    private var name: Output<String>? = null

    /**
     * @param value Whether the configuration recorder should be enabled or disabled.
     */
    @JvmName("avfggnlgjvlywwhg")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value The name of the recorder
     */
    @JvmName("tuquxsdfkovtwmne")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Whether the configuration recorder should be enabled or disabled.
     */
    @JvmName("kshlumhcekbplnew")
    public suspend fun isEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value The name of the recorder
     */
    @JvmName("boryrgvpvfcmqhcm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): RecorderStatusArgs = RecorderStatusArgs(
        isEnabled = isEnabled,
        name = name,
    )
}
