@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin

import com.pulumi.aws.cfg.RemediationConfigurationArgs.builder
import com.pulumi.aws.cfg.kotlin.inputs.RemediationConfigurationExecutionControlsArgs
import com.pulumi.aws.cfg.kotlin.inputs.RemediationConfigurationExecutionControlsArgsBuilder
import com.pulumi.aws.cfg.kotlin.inputs.RemediationConfigurationParameterArgs
import com.pulumi.aws.cfg.kotlin.inputs.RemediationConfigurationParameterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an AWS Config Remediation Configuration.
 * > **Note:** Config Remediation Configuration requires an existing Config Rule to be present.
 * ## Example Usage
 * AWS managed rules can be used by setting the source owner to `AWS` and the source identifier to the name of the managed rule. More information about AWS managed rules can be found in the [AWS Config Developer Guide](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html).
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cfg.Rule;
 * import com.pulumi.aws.cfg.RuleArgs;
 * import com.pulumi.aws.cfg.inputs.RuleSourceArgs;
 * import com.pulumi.aws.cfg.RemediationConfiguration;
 * import com.pulumi.aws.cfg.RemediationConfigurationArgs;
 * import com.pulumi.aws.cfg.inputs.RemediationConfigurationParameterArgs;
 * import com.pulumi.aws.cfg.inputs.RemediationConfigurationExecutionControlsArgs;
 * import com.pulumi.aws.cfg.inputs.RemediationConfigurationExecutionControlsSsmControlsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var thisRule = new Rule("thisRule", RuleArgs.builder()
 *             .source(RuleSourceArgs.builder()
 *                 .owner("AWS")
 *                 .sourceIdentifier("S3_BUCKET_VERSIONING_ENABLED")
 *                 .build())
 *             .build());
 *         var thisRemediationConfiguration = new RemediationConfiguration("thisRemediationConfiguration", RemediationConfigurationArgs.builder()
 *             .configRuleName(thisRule.name())
 *             .resourceType("AWS::S3::Bucket")
 *             .targetType("SSM_DOCUMENT")
 *             .targetId("AWS-EnableS3BucketEncryption")
 *             .targetVersion("1")
 *             .parameters(
 *                 RemediationConfigurationParameterArgs.builder()
 *                     .name("AutomationAssumeRole")
 *                     .staticValue("arn:aws:iam::875924563244:role/security_config")
 *                     .build(),
 *                 RemediationConfigurationParameterArgs.builder()
 *                     .name("BucketName")
 *                     .resourceValue("RESOURCE_ID")
 *                     .build(),
 *                 RemediationConfigurationParameterArgs.builder()
 *                     .name("SSEAlgorithm")
 *                     .staticValue("AES256")
 *                     .build())
 *             .automatic(true)
 *             .maximumAutomaticAttempts(10)
 *             .retryAttemptSeconds(600)
 *             .executionControls(RemediationConfigurationExecutionControlsArgs.builder()
 *                 .ssmControls(RemediationConfigurationExecutionControlsSsmControlsArgs.builder()
 *                     .concurrentExecutionRatePercentage(25)
 *                     .errorPercentage(20)
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Remediation Configurations using the name config_rule_name. For example:
 * ```sh
 *  $ pulumi import aws:cfg/remediationConfiguration:RemediationConfiguration this example
 * ```
 * @property automatic Remediation is triggered automatically if `true`.
 * @property configRuleName Name of the AWS Config rule.
 * @property executionControls Configuration block for execution controls. See below.
 * @property maximumAutomaticAttempts Maximum number of failed attempts for auto-remediation. If you do not select a number, the default is 5.
 * @property parameters Can be specified multiple times for each parameter. Each parameter block supports arguments below.
 * @property resourceType Type of resource.
 * @property retryAttemptSeconds Maximum time in seconds that AWS Config runs auto-remediation. If you do not select a number, the default is 60 seconds.
 * @property targetId Target ID is the name of the public document.
 * @property targetType Type of the target. Target executes remediation. For example, SSM document.
 * The following arguments are optional:
 * @property targetVersion Version of the target. For example, version of the SSM document
 */
public data class RemediationConfigurationArgs(
    public val automatic: Output<Boolean>? = null,
    public val configRuleName: Output<String>? = null,
    public val executionControls: Output<RemediationConfigurationExecutionControlsArgs>? = null,
    public val maximumAutomaticAttempts: Output<Int>? = null,
    public val parameters: Output<List<RemediationConfigurationParameterArgs>>? = null,
    public val resourceType: Output<String>? = null,
    public val retryAttemptSeconds: Output<Int>? = null,
    public val targetId: Output<String>? = null,
    public val targetType: Output<String>? = null,
    public val targetVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cfg.RemediationConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.cfg.RemediationConfigurationArgs =
        com.pulumi.aws.cfg.RemediationConfigurationArgs.builder()
            .automatic(automatic?.applyValue({ args0 -> args0 }))
            .configRuleName(configRuleName?.applyValue({ args0 -> args0 }))
            .executionControls(executionControls?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .maximumAutomaticAttempts(maximumAutomaticAttempts?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceType(resourceType?.applyValue({ args0 -> args0 }))
            .retryAttemptSeconds(retryAttemptSeconds?.applyValue({ args0 -> args0 }))
            .targetId(targetId?.applyValue({ args0 -> args0 }))
            .targetType(targetType?.applyValue({ args0 -> args0 }))
            .targetVersion(targetVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RemediationConfigurationArgs].
 */
@PulumiTagMarker
public class RemediationConfigurationArgsBuilder internal constructor() {
    private var automatic: Output<Boolean>? = null

    private var configRuleName: Output<String>? = null

    private var executionControls: Output<RemediationConfigurationExecutionControlsArgs>? = null

    private var maximumAutomaticAttempts: Output<Int>? = null

    private var parameters: Output<List<RemediationConfigurationParameterArgs>>? = null

    private var resourceType: Output<String>? = null

    private var retryAttemptSeconds: Output<Int>? = null

    private var targetId: Output<String>? = null

    private var targetType: Output<String>? = null

    private var targetVersion: Output<String>? = null

    /**
     * @param value Remediation is triggered automatically if `true`.
     */
    @JvmName("tejlbxnelsmpsomk")
    public suspend fun automatic(`value`: Output<Boolean>) {
        this.automatic = value
    }

    /**
     * @param value Name of the AWS Config rule.
     */
    @JvmName("uotsmqddrxpwaoge")
    public suspend fun configRuleName(`value`: Output<String>) {
        this.configRuleName = value
    }

    /**
     * @param value Configuration block for execution controls. See below.
     */
    @JvmName("qkjqiqvrtwwknunv")
    public suspend
    fun executionControls(`value`: Output<RemediationConfigurationExecutionControlsArgs>) {
        this.executionControls = value
    }

    /**
     * @param value Maximum number of failed attempts for auto-remediation. If you do not select a number, the default is 5.
     */
    @JvmName("gmaobbfpwlqpnbiy")
    public suspend fun maximumAutomaticAttempts(`value`: Output<Int>) {
        this.maximumAutomaticAttempts = value
    }

    /**
     * @param value Can be specified multiple times for each parameter. Each parameter block supports arguments below.
     */
    @JvmName("ygwhnllsvifvvscg")
    public suspend fun parameters(`value`: Output<List<RemediationConfigurationParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("kpqxwuxiivldvmbq")
    public suspend fun parameters(vararg values: Output<RemediationConfigurationParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values Can be specified multiple times for each parameter. Each parameter block supports arguments below.
     */
    @JvmName("ahwfpeodviycyhek")
    public suspend fun parameters(values: List<Output<RemediationConfigurationParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value Type of resource.
     */
    @JvmName("qikeommnhqyckpfh")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value Maximum time in seconds that AWS Config runs auto-remediation. If you do not select a number, the default is 60 seconds.
     */
    @JvmName("xbrfofnftfvgqvth")
    public suspend fun retryAttemptSeconds(`value`: Output<Int>) {
        this.retryAttemptSeconds = value
    }

    /**
     * @param value Target ID is the name of the public document.
     */
    @JvmName("phrwpsotrxawumfr")
    public suspend fun targetId(`value`: Output<String>) {
        this.targetId = value
    }

    /**
     * @param value Type of the target. Target executes remediation. For example, SSM document.
     * The following arguments are optional:
     */
    @JvmName("dokbkrhjvyoquhwp")
    public suspend fun targetType(`value`: Output<String>) {
        this.targetType = value
    }

    /**
     * @param value Version of the target. For example, version of the SSM document
     */
    @JvmName("lvqsgbknfnckoyen")
    public suspend fun targetVersion(`value`: Output<String>) {
        this.targetVersion = value
    }

    /**
     * @param value Remediation is triggered automatically if `true`.
     */
    @JvmName("gfisuivylrfvwluv")
    public suspend fun automatic(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automatic = mapped
    }

    /**
     * @param value Name of the AWS Config rule.
     */
    @JvmName("wgwvpryxbvdymmej")
    public suspend fun configRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configRuleName = mapped
    }

    /**
     * @param value Configuration block for execution controls. See below.
     */
    @JvmName("olitwsbxdtlxlpnc")
    public suspend fun executionControls(`value`: RemediationConfigurationExecutionControlsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.executionControls = mapped
    }

    /**
     * @param argument Configuration block for execution controls. See below.
     */
    @JvmName("ikygoeodllqilurr")
    public suspend
    fun executionControls(argument: suspend RemediationConfigurationExecutionControlsArgsBuilder.() -> Unit) {
        val toBeMapped = RemediationConfigurationExecutionControlsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.executionControls = mapped
    }

    /**
     * @param value Maximum number of failed attempts for auto-remediation. If you do not select a number, the default is 5.
     */
    @JvmName("pmqjjrjbliqprboo")
    public suspend fun maximumAutomaticAttempts(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumAutomaticAttempts = mapped
    }

    /**
     * @param value Can be specified multiple times for each parameter. Each parameter block supports arguments below.
     */
    @JvmName("ekicjegxxxjoqetf")
    public suspend fun parameters(`value`: List<RemediationConfigurationParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Can be specified multiple times for each parameter. Each parameter block supports arguments below.
     */
    @JvmName("myvrguadicojjdye")
    public suspend
    fun parameters(argument: List<suspend RemediationConfigurationParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RemediationConfigurationParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Can be specified multiple times for each parameter. Each parameter block supports arguments below.
     */
    @JvmName("dyxkwfxgqspvbkgo")
    public suspend fun parameters(
        vararg
        argument: suspend RemediationConfigurationParameterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RemediationConfigurationParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Can be specified multiple times for each parameter. Each parameter block supports arguments below.
     */
    @JvmName("wxllmuwccsycbony")
    public suspend
    fun parameters(argument: suspend RemediationConfigurationParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RemediationConfigurationParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Can be specified multiple times for each parameter. Each parameter block supports arguments below.
     */
    @JvmName("yuxurbetygeaxnqy")
    public suspend fun parameters(vararg values: RemediationConfigurationParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Type of resource.
     */
    @JvmName("yrqhgsdupjsklyuy")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value Maximum time in seconds that AWS Config runs auto-remediation. If you do not select a number, the default is 60 seconds.
     */
    @JvmName("kvwmfkhkxeatxenf")
    public suspend fun retryAttemptSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retryAttemptSeconds = mapped
    }

    /**
     * @param value Target ID is the name of the public document.
     */
    @JvmName("mnaaxqmujlwuhlgu")
    public suspend fun targetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetId = mapped
    }

    /**
     * @param value Type of the target. Target executes remediation. For example, SSM document.
     * The following arguments are optional:
     */
    @JvmName("jaqmhltttnmjfgfl")
    public suspend fun targetType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetType = mapped
    }

    /**
     * @param value Version of the target. For example, version of the SSM document
     */
    @JvmName("rglpcjjinymjmvvt")
    public suspend fun targetVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetVersion = mapped
    }

    internal fun build(): RemediationConfigurationArgs = RemediationConfigurationArgs(
        automatic = automatic,
        configRuleName = configRuleName,
        executionControls = executionControls,
        maximumAutomaticAttempts = maximumAutomaticAttempts,
        parameters = parameters,
        resourceType = resourceType,
        retryAttemptSeconds = retryAttemptSeconds,
        targetId = targetId,
        targetType = targetType,
        targetVersion = targetVersion,
    )
}
