@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin

import com.pulumi.aws.cfg.kotlin.outputs.RuleEvaluationMode
import com.pulumi.aws.cfg.kotlin.outputs.RuleScope
import com.pulumi.aws.cfg.kotlin.outputs.RuleSource
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.cfg.kotlin.outputs.RuleEvaluationMode.Companion.toKotlin as ruleEvaluationModeToKotlin
import com.pulumi.aws.cfg.kotlin.outputs.RuleScope.Companion.toKotlin as ruleScopeToKotlin
import com.pulumi.aws.cfg.kotlin.outputs.RuleSource.Companion.toKotlin as ruleSourceToKotlin

/**
 * Builder for [Rule].
 */
@PulumiTagMarker
public class RuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RuleArgs = RuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RuleArgsBuilder.() -> Unit) {
        val builder = RuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Rule {
        val builtJavaResource = com.pulumi.aws.cfg.Rule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Rule(builtJavaResource)
    }
}

/**
 * Provides an AWS Config Rule.
 * > **Note:** Config Rule requires an existing Configuration Recorder to be present. Use of `depends_on` is recommended (as shown below) to avoid race conditions.
 * ## Example Usage
 * ### AWS Managed Rules
 * AWS managed rules can be used by setting the source owner to `AWS` and the source identifier to the name of the managed rule. More information about AWS managed rules can be found in the [AWS Config Developer Guide](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html).
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.cfg.Recorder;
 * import com.pulumi.aws.cfg.RecorderArgs;
 * import com.pulumi.aws.cfg.Rule;
 * import com.pulumi.aws.cfg.RuleArgs;
 * import com.pulumi.aws.cfg.inputs.RuleSourceArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("config.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var role = new Role("role", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var foo = new Recorder("foo", RecorderArgs.builder()
 *             .roleArn(role.arn())
 *             .build());
 *         var rule = new Rule("rule", RuleArgs.builder()
 *             .source(RuleSourceArgs.builder()
 *                 .owner("AWS")
 *                 .sourceIdentifier("S3_BUCKET_VERSIONING_ENABLED")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(foo)
 *                 .build());
 *         final var policyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("config:Put*")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var rolePolicy = new RolePolicy("rolePolicy", RolePolicyArgs.builder()
 *             .role(role.id())
 *             .policy(policyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *     }
 * }
 * ```
 * ### Custom Rules
 * Custom rules can be used by setting the source owner to `CUSTOM_LAMBDA` and the source identifier to the Amazon Resource Name (ARN) of the Lambda Function. The AWS Config service must have permissions to invoke the Lambda Function, e.g., via the `aws.lambda.Permission` resource. More information about custom rules can be found in the [AWS Config Developer Guide](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_develop-rules.html).
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cfg.Recorder;
 * import com.pulumi.aws.lambda.Function;
 * import com.pulumi.aws.lambda.Permission;
 * import com.pulumi.aws.lambda.PermissionArgs;
 * import com.pulumi.aws.cfg.Rule;
 * import com.pulumi.aws.cfg.RuleArgs;
 * import com.pulumi.aws.cfg.inputs.RuleSourceArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleRecorder = new Recorder("exampleRecorder");
 *         var exampleFunction = new Function("exampleFunction");
 *         var examplePermission = new Permission("examplePermission", PermissionArgs.builder()
 *             .action("lambda:InvokeFunction")
 *             .function(exampleFunction.arn())
 *             .principal("config.amazonaws.com")
 *             .build());
 *         var exampleRule = new Rule("exampleRule", RuleArgs.builder()
 *             .source(RuleSourceArgs.builder()
 *                 .owner("CUSTOM_LAMBDA")
 *                 .sourceIdentifier(exampleFunction.arn())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(
 *                     exampleRecorder,
 *                     examplePermission)
 *                 .build());
 *     }
 * }
 * ```
 * ### Custom Policies
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cfg.Rule;
 * import com.pulumi.aws.cfg.RuleArgs;
 * import com.pulumi.aws.cfg.inputs.RuleSourceArgs;
 * import com.pulumi.aws.cfg.inputs.RuleSourceCustomPolicyDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Rule("example", RuleArgs.builder()
 *             .source(RuleSourceArgs.builder()
 *                 .owner("CUSTOM_POLICY")
 *                 .sourceDetails(RuleSourceSourceDetailArgs.builder()
 *                     .messageType("ConfigurationItemChangeNotification")
 *                     .build())
 *                 .customPolicyDetails(RuleSourceCustomPolicyDetailsArgs.builder()
 *                     .policyRuntime("guard-2.x.x")
 *                     .policyText("""
 * 	  rule tableisactive when
 * 		  resourceType == "AWS::DynamoDB::Table" {
 * 		  configuration.tableStatus == ['ACTIVE']
 * 	  }
 * 	  rule checkcompliance when
 * 		  resourceType == "AWS::DynamoDB::Table"
 * 		  tableisactive {
 * 			  supplementaryConfiguration.ContinuousBackupsDescription.pointInTimeRecoveryDescription.pointInTimeRecoveryStatus == "ENABLED"
 * 	  }
 *                     """)
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Config Rule using the name. For example:
 * ```sh
 *  $ pulumi import aws:cfg/rule:Rule foo example
 * ```
 *
 */
public class Rule internal constructor(
    override val javaResource: com.pulumi.aws.cfg.Rule,
) : KotlinCustomResource(javaResource, RuleMapper) {
    /**
     * The ARN of the config rule
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Description of the rule
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The modes the Config rule can be evaluated in. See Evaluation Mode for more details.
     */
    public val evaluationModes: Output<List<RuleEvaluationMode>>
        get() = javaResource.evaluationModes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> ruleEvaluationModeToKotlin(args0) })
            })
        })

    /**
     * A string in JSON format that is passed to the AWS Config rule Lambda function.
     */
    public val inputParameters: Output<String>?
        get() = javaResource.inputParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The maximum frequency with which AWS Config runs evaluations for a rule.
     */
    public val maximumExecutionFrequency: Output<String>?
        get() = javaResource.maximumExecutionFrequency().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the rule
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The ID of the config rule
     */
    public val ruleId: Output<String>
        get() = javaResource.ruleId().applyValue({ args0 -> args0 })

    /**
     * Scope defines which resources can trigger an evaluation for the rule. See Source Below.
     */
    public val scope: Output<RuleScope>?
        get() = javaResource.scope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    ruleScopeToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Source specifies the rule owner, the rule identifier, and the notifications that cause the function to evaluate your AWS resources. See Scope Below.
     */
    public val source: Output<RuleSource>
        get() = javaResource.source().applyValue({ args0 ->
            args0.let({ args0 ->
                ruleSourceToKotlin(args0)
            })
        })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object RuleMapper : ResourceMapper<Rule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cfg.Rule::class == javaResource::class

    override fun map(javaResource: Resource): Rule = Rule(javaResource as com.pulumi.aws.cfg.Rule)
}

/**
 * @see [Rule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Rule].
 */
public suspend fun rule(name: String, block: suspend RuleResourceBuilder.() -> Unit): Rule {
    val builder = RuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Rule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun rule(name: String): Rule {
    val builder = RuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
