@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin

import com.pulumi.aws.cfg.RuleArgs.builder
import com.pulumi.aws.cfg.kotlin.inputs.RuleEvaluationModeArgs
import com.pulumi.aws.cfg.kotlin.inputs.RuleEvaluationModeArgsBuilder
import com.pulumi.aws.cfg.kotlin.inputs.RuleScopeArgs
import com.pulumi.aws.cfg.kotlin.inputs.RuleScopeArgsBuilder
import com.pulumi.aws.cfg.kotlin.inputs.RuleSourceArgs
import com.pulumi.aws.cfg.kotlin.inputs.RuleSourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AWS Config Rule.
 * > **Note:** Config Rule requires an existing Configuration Recorder to be present. Use of `depends_on` is recommended (as shown below) to avoid race conditions.
 * ## Example Usage
 * ### AWS Managed Rules
 * AWS managed rules can be used by setting the source owner to `AWS` and the source identifier to the name of the managed rule. More information about AWS managed rules can be found in the [AWS Config Developer Guide](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html).
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.cfg.Recorder;
 * import com.pulumi.aws.cfg.RecorderArgs;
 * import com.pulumi.aws.cfg.Rule;
 * import com.pulumi.aws.cfg.RuleArgs;
 * import com.pulumi.aws.cfg.inputs.RuleSourceArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("config.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var role = new Role("role", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var foo = new Recorder("foo", RecorderArgs.builder()
 *             .roleArn(role.arn())
 *             .build());
 *         var rule = new Rule("rule", RuleArgs.builder()
 *             .source(RuleSourceArgs.builder()
 *                 .owner("AWS")
 *                 .sourceIdentifier("S3_BUCKET_VERSIONING_ENABLED")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(foo)
 *                 .build());
 *         final var policyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("config:Put*")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var rolePolicy = new RolePolicy("rolePolicy", RolePolicyArgs.builder()
 *             .role(role.id())
 *             .policy(policyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *     }
 * }
 * ```
 * ### Custom Rules
 * Custom rules can be used by setting the source owner to `CUSTOM_LAMBDA` and the source identifier to the Amazon Resource Name (ARN) of the Lambda Function. The AWS Config service must have permissions to invoke the Lambda Function, e.g., via the `aws.lambda.Permission` resource. More information about custom rules can be found in the [AWS Config Developer Guide](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_develop-rules.html).
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cfg.Recorder;
 * import com.pulumi.aws.lambda.Function;
 * import com.pulumi.aws.lambda.Permission;
 * import com.pulumi.aws.lambda.PermissionArgs;
 * import com.pulumi.aws.cfg.Rule;
 * import com.pulumi.aws.cfg.RuleArgs;
 * import com.pulumi.aws.cfg.inputs.RuleSourceArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleRecorder = new Recorder("exampleRecorder");
 *         var exampleFunction = new Function("exampleFunction");
 *         var examplePermission = new Permission("examplePermission", PermissionArgs.builder()
 *             .action("lambda:InvokeFunction")
 *             .function(exampleFunction.arn())
 *             .principal("config.amazonaws.com")
 *             .build());
 *         var exampleRule = new Rule("exampleRule", RuleArgs.builder()
 *             .source(RuleSourceArgs.builder()
 *                 .owner("CUSTOM_LAMBDA")
 *                 .sourceIdentifier(exampleFunction.arn())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(
 *                     exampleRecorder,
 *                     examplePermission)
 *                 .build());
 *     }
 * }
 * ```
 * ### Custom Policies
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cfg.Rule;
 * import com.pulumi.aws.cfg.RuleArgs;
 * import com.pulumi.aws.cfg.inputs.RuleSourceArgs;
 * import com.pulumi.aws.cfg.inputs.RuleSourceCustomPolicyDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Rule("example", RuleArgs.builder()
 *             .source(RuleSourceArgs.builder()
 *                 .owner("CUSTOM_POLICY")
 *                 .sourceDetails(RuleSourceSourceDetailArgs.builder()
 *                     .messageType("ConfigurationItemChangeNotification")
 *                     .build())
 *                 .customPolicyDetails(RuleSourceCustomPolicyDetailsArgs.builder()
 *                     .policyRuntime("guard-2.x.x")
 *                     .policyText("""
 * 	  rule tableisactive when
 * 		  resourceType == "AWS::DynamoDB::Table" {
 * 		  configuration.tableStatus == ['ACTIVE']
 * 	  }
 * 	  rule checkcompliance when
 * 		  resourceType == "AWS::DynamoDB::Table"
 * 		  tableisactive {
 * 			  supplementaryConfiguration.ContinuousBackupsDescription.pointInTimeRecoveryDescription.pointInTimeRecoveryStatus == "ENABLED"
 * 	  }
 *                     """)
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Config Rule using the name. For example:
 * ```sh
 *  $ pulumi import aws:cfg/rule:Rule foo example
 * ```
 * @property description Description of the rule
 * @property evaluationModes The modes the Config rule can be evaluated in. See Evaluation Mode for more details.
 * @property inputParameters A string in JSON format that is passed to the AWS Config rule Lambda function.
 * @property maximumExecutionFrequency The maximum frequency with which AWS Config runs evaluations for a rule.
 * @property name The name of the rule
 * @property scope Scope defines which resources can trigger an evaluation for the rule. See Source Below.
 * @property source Source specifies the rule owner, the rule identifier, and the notifications that cause the function to evaluate your AWS resources. See Scope Below.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class RuleArgs(
    public val description: Output<String>? = null,
    public val evaluationModes: Output<List<RuleEvaluationModeArgs>>? = null,
    public val inputParameters: Output<String>? = null,
    public val maximumExecutionFrequency: Output<String>? = null,
    public val name: Output<String>? = null,
    public val scope: Output<RuleScopeArgs>? = null,
    public val source: Output<RuleSourceArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.cfg.RuleArgs> {
    override fun toJava(): com.pulumi.aws.cfg.RuleArgs = com.pulumi.aws.cfg.RuleArgs.builder()
        .description(description?.applyValue({ args0 -> args0 }))
        .evaluationModes(
            evaluationModes?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .inputParameters(inputParameters?.applyValue({ args0 -> args0 }))
        .maximumExecutionFrequency(maximumExecutionFrequency?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .scope(scope?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .source(source?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [RuleArgs].
 */
@PulumiTagMarker
public class RuleArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var evaluationModes: Output<List<RuleEvaluationModeArgs>>? = null

    private var inputParameters: Output<String>? = null

    private var maximumExecutionFrequency: Output<String>? = null

    private var name: Output<String>? = null

    private var scope: Output<RuleScopeArgs>? = null

    private var source: Output<RuleSourceArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Description of the rule
     */
    @JvmName("asvvshqmbrnuegcy")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The modes the Config rule can be evaluated in. See Evaluation Mode for more details.
     */
    @JvmName("fbxrialoxrnotiss")
    public suspend fun evaluationModes(`value`: Output<List<RuleEvaluationModeArgs>>) {
        this.evaluationModes = value
    }

    @JvmName("anymwqjcstgflych")
    public suspend fun evaluationModes(vararg values: Output<RuleEvaluationModeArgs>) {
        this.evaluationModes = Output.all(values.asList())
    }

    /**
     * @param values The modes the Config rule can be evaluated in. See Evaluation Mode for more details.
     */
    @JvmName("fnucnmhujmjwgamb")
    public suspend fun evaluationModes(values: List<Output<RuleEvaluationModeArgs>>) {
        this.evaluationModes = Output.all(values)
    }

    /**
     * @param value A string in JSON format that is passed to the AWS Config rule Lambda function.
     */
    @JvmName("snjohvymagbisxgu")
    public suspend fun inputParameters(`value`: Output<String>) {
        this.inputParameters = value
    }

    /**
     * @param value The maximum frequency with which AWS Config runs evaluations for a rule.
     */
    @JvmName("hlcycontqpywjxdi")
    public suspend fun maximumExecutionFrequency(`value`: Output<String>) {
        this.maximumExecutionFrequency = value
    }

    /**
     * @param value The name of the rule
     */
    @JvmName("fvqajlhqjfdwpurq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Scope defines which resources can trigger an evaluation for the rule. See Source Below.
     */
    @JvmName("gewtkiuxqqwhdnyp")
    public suspend fun scope(`value`: Output<RuleScopeArgs>) {
        this.scope = value
    }

    /**
     * @param value Source specifies the rule owner, the rule identifier, and the notifications that cause the function to evaluate your AWS resources. See Scope Below.
     */
    @JvmName("rffjjeqmorjlkqvm")
    public suspend fun source(`value`: Output<RuleSourceArgs>) {
        this.source = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("uaqijluqepsmhelr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Description of the rule
     */
    @JvmName("jjglumxknchagpyy")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The modes the Config rule can be evaluated in. See Evaluation Mode for more details.
     */
    @JvmName("sklvqtkhoxrbgmnn")
    public suspend fun evaluationModes(`value`: List<RuleEvaluationModeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.evaluationModes = mapped
    }

    /**
     * @param argument The modes the Config rule can be evaluated in. See Evaluation Mode for more details.
     */
    @JvmName("wcgcpnhvppjhlpae")
    public suspend
    fun evaluationModes(argument: List<suspend RuleEvaluationModeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleEvaluationModeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.evaluationModes = mapped
    }

    /**
     * @param argument The modes the Config rule can be evaluated in. See Evaluation Mode for more details.
     */
    @JvmName("sqigehlhflobjvte")
    public suspend fun evaluationModes(
        vararg
        argument: suspend RuleEvaluationModeArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RuleEvaluationModeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.evaluationModes = mapped
    }

    /**
     * @param argument The modes the Config rule can be evaluated in. See Evaluation Mode for more details.
     */
    @JvmName("gfmidbtrqoffcixw")
    public suspend fun evaluationModes(argument: suspend RuleEvaluationModeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RuleEvaluationModeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.evaluationModes = mapped
    }

    /**
     * @param values The modes the Config rule can be evaluated in. See Evaluation Mode for more details.
     */
    @JvmName("qntkeauguirpqqii")
    public suspend fun evaluationModes(vararg values: RuleEvaluationModeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.evaluationModes = mapped
    }

    /**
     * @param value A string in JSON format that is passed to the AWS Config rule Lambda function.
     */
    @JvmName("cwgfcwxwrttqjgbm")
    public suspend fun inputParameters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputParameters = mapped
    }

    /**
     * @param value The maximum frequency with which AWS Config runs evaluations for a rule.
     */
    @JvmName("prsbppgsodnpquvg")
    public suspend fun maximumExecutionFrequency(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumExecutionFrequency = mapped
    }

    /**
     * @param value The name of the rule
     */
    @JvmName("fhqpqoapyosbkhma")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Scope defines which resources can trigger an evaluation for the rule. See Source Below.
     */
    @JvmName("fgrnvgxlugektwdr")
    public suspend fun scope(`value`: RuleScopeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param argument Scope defines which resources can trigger an evaluation for the rule. See Source Below.
     */
    @JvmName("nrjjjpwgwcsitjrq")
    public suspend fun scope(argument: suspend RuleScopeArgsBuilder.() -> Unit) {
        val toBeMapped = RuleScopeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scope = mapped
    }

    /**
     * @param value Source specifies the rule owner, the rule identifier, and the notifications that cause the function to evaluate your AWS resources. See Scope Below.
     */
    @JvmName("hnkrobegskoidkru")
    public suspend fun source(`value`: RuleSourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param argument Source specifies the rule owner, the rule identifier, and the notifications that cause the function to evaluate your AWS resources. See Scope Below.
     */
    @JvmName("gmjhyfjsqpuuualn")
    public suspend fun source(argument: suspend RuleSourceArgsBuilder.() -> Unit) {
        val toBeMapped = RuleSourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.source = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dumyfasipdaegjbs")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tgvigdphhruhgiaw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RuleArgs = RuleArgs(
        description = description,
        evaluationModes = evaluationModes,
        inputParameters = inputParameters,
        maximumExecutionFrequency = maximumExecutionFrequency,
        name = name,
        scope = scope,
        source = source,
        tags = tags,
    )
}
